;;**************************************************************************
;;                          tasks.asm    tasks.asm
;;**************************************************************************
;; 
;;*************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;**************************************************************************
;;
;; tasks.asm is the module that provides the multitasking capability for
;; programs.  These really aren't even tasks anymore, they are simply 
;; a nice way of breaking up the program.
;;
;; This module assumes that there will be only one scheduler.  
;;
;; The routines declared here dealing with the task scheduler
;;
;;   SCHED_DECLARE num_tasks
;;   TASK_DEFINE task, code
;;   TASK_RETURN task
;;   SCHED_RUN 
;;
;;**************************************************************************


;;****************************************************************************
;; SCHED_DECLARE num_tasks
;;
;;  SCHED_DECLARE declares a task scheduler that has 'num_tasks' in its
;;  run queue.  This scheduler is VERY light and VERY primitive.  The
;;  tasks are aways run bound and the run queue never changes.  Even so
;;  this is sufficient for the PCrouter.

SCHED_DECLARE   MACRO num_tasks
    .errb <num_tasks>

sched_num_tasks = num_tasks

    IRP idx, <1,2,3,4,5,6,7,8,9>
    if idx le num_tasks
        SCHED_HELPER idx
    endif
    endm
ENDM

SCHED_HELPER MACRO task
    .CODE
    global sched_task_&task:near
ENDM

;;****************************************************************************
;; SCHED_RUN 
;;
;;  SCHED_RUN runs the tasks in the run queue.  This routine is meant to
;;  be called after all the tasks have been defined with TASK_DEFINE
;;  and you wish to begin scheduling.  The macro NEVER returns.
;;
SCHED_RUN   MACRO 
    jmp sched_task_1
ENDM


;;****************************************************************************
;; TASK_DEFINE task, code
;;
;; TASK_DEFINE defines the task 'task' (which must be a number from 
;; 1..num_tasks) to start at the label 'code'.   This code will be 
;; run when 'SCHED_RUN is called
;;
TASK_DEFINE MACRO task, code
    .errb <code>

sched_task_&task = code
ENDM

;;****************************************************************************
;; TASK_RETURN task
;;
;; TASK_RETURN is to be called when the task wants to reliquish control
;; of the CPU.  NOTE THAT CONTROL WILL BE GIVEN BACK AT THE STARTING
;; POINT NOT AT THE POINT OF THE TASK_RETURN CALL
;;
TASK_RETURN MACRO task
    .errb <task>

    new_task = task + 1
    if new_task gt sched_num_tasks
        new_task = 1
    endif
    TASK_HELPER task, %new_task
ENDM

TASK_HELPER MACRO task, new_task
    jmp sched_task_&new_task
ENDM

