;;************************************************************************* 
;                         icmp.asm       icmp.asm
;;*************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;*****************************************************************************
;;
;; Routines provided by this package
;;
;;      ICMP_DECLARE name, net, router
;;      ICMP_DEFINE name
;;      ICMP_ERROR_in_SI_ES name, type, code, ip
;;      ICMP_REDIRECT_in_AX_BX_SI_ES name, code, ip
;;  
;; AUTHOR: Vance Morrison
;; DATE:  5/9/89
;;*****************************************************************************

ICMP_PROTO          = 1         

;; values for the type field
ICMP_ECHO_REPLY     = 0
ICMP_ECHO_REQUEST   = 8
ICMP_TIME           = 11
ICMP_UNREACHABLE    = 3
ICMP_REDIRECT       = 5

;; values for the code field
ICMP_TIME_TTL       = 0

ICMP_UNREACH_NET    = 0
ICMP_UNREACH_HOST   = 1
ICMP_UNREACH_PROTO  = 2
ICMP_UNREACH_PORT   = 3

ICMP_REDIRECT_NET        = 0
ICMP_REDIRECT_HOST       = 1
ICMP_REDIRECT_TOS_NET    = 2
ICMP_REDIRECT_TOS_HOST   = 3

icmp STRUC           ;; icmp packets
    icmp_type       DB
    icmp_code       DB
    icmp_check      DW
    icmp_id         DW
    icmp_seq        DW
icmp ENDS

icmp_data   STRUC
    icmp_read_off   DW
    icmp_read_seg   DW
    icmp_read_len   DW
    icmp_error_off  DW
    icmp_error_seg  DW
    icmp_gateway    DD
icmp_data   ENDS


;;*****************************************************************************
;;   ICMP_DECLARE name, net, router
;; 
ICMP_DECLARE MACRO name, net, router
    .errb <router>

    .DATA
    icmp_&name&_net = net
    icmp_&name&_router = router
    global icmp_&name&_data:icmp_data
    .CODE
ENDM

;;*****************************************************************************
;;   ICMP_DEFINE name
;;      ARP_DEFINE declare all the things that have to be defined in
;;      every independantly assembled module.  DL_IP declares those
;;      things that need be be done only once (in particular memory allocation
;;      and initialzation code).  
;; 
ICMP_DEFINE MACRO name
    local icmp_packet, around
    .errb <name>

    .DATA
    icmp_&name&_data icmp_data <>

    .CODE
    jmp around                                  ;; set up the listener
        icmp_packet:
            ICMP_PACKET_in_BX_ES name
            RET
    around:
    IP_R_READ %icmp_&name&_net, ICMP_PROTO, icmp_packet
ENDM


;;*****************************************************************************
;;      ICMP_REDIRECT_in_AX_BX_SI_ES name, code
;;  ICMP_REDIRECT sends a redirect with the ICMP code of 'code' to the host 
;;  sending the IP packet SI:ES instructing this host to redirect packets
;;  to the gateway AX,BX
;;
ICMP_REDIRECT_in_AX_BX_SI_ES MACRO name, code, ip
    local done
    .errb <ip>

    ICMP_DO_REPLY_in_AX_BX_SI_ES name, ICMP_REDIRECT, code, ip
ENDM



;;*****************************************************************************
;; ICMP_ERROR_in_SI_ES returns an error code of type 'type' and code 'code'
;; to the sender of the IP packet pointed to by SI:ES
;;
ICMP_ERROR_in_SI_ES MACRO name, type, code, ip
    local done
    .errb <ip>

    xor AX, AX
    xor BX, BX
    ICMP_DO_REPLY_in_AX_BX_SI_ES name, type, code, ip
ENDM



;;*****************************************************************************
;; ICMP_DO_REPLY returns an error code of type 'type' and code 'code'
;; to the sender of the IP packet pointed to by SI:ES with the gatway part
;; of the header set to AX,BX
;;
ICMP_DO_REPLY_in_AX_BX_SI_ES MACRO name, type, code, ip
    local done
    .errb <ip>

    cmp byte ptr ES:[SI+ip_proto], ICMP_PROTO       ;; no errors about ICMP
    jz done
        mov word ptr icmp_&name&_data.icmp_gateway,   AX
        mov word ptr icmp_&name&_data.icmp_gateway+2, BX

        mov word ptr icmp_&name&_data.icmp_error_off, SI
        mov word ptr icmp_&name&_data.icmp_error_seg, ES

        mov AX, word ptr ES:[SI+ip_src]
        mov BX, word ptr ES:[SI+ip_src+2]

        mov DL, ICMP_PROTO
        mov CX, 8+60+8
        IP_W_ACCESS_in_AX_BX_CX_DL_out_AX_DI_ES ip
        or AX, AX
        jnz done            ;; check return code
        mov BP, DI          ;; save DI
        
        mov AL, type        ;; fill in the header
        mov AH, code
        stosw

        xor AX, AX
        stosw               ;; the checksum

        mov AX, word ptr icmp_&name&_data.icmp_gateway
        stosw
        mov AX, word ptr icmp_&name&_data.icmp_gateway+2
        stosw

        mov BX, DS                                  ;; save DS
        lds SI, dword ptr icmp_&name&_data.icmp_error_off

        mov CX, 28
        mov DX, CX                                  ;; save CX
        rep                                         ;; copy the packet
        movsb
        mov DS, BX                                  ;; restore DS

        add DX, 8
        mov CX, DX                                  ;; restore CX
        mov SI, BP          ;; restore packet pointer
        ICMP_COMPUTE_CHECK_in_CX_SI_ES_out_BX_const_DX_BP_DI_ES 
        mov DI, BP
        mov word ptr ES:[DI+icmp_check], BX

        mov CX, DX
        IP_W_WRITE_in_CX ip
    done:
ENDM


;;*****************************************************************************
ICMP_COMPUTE_CHECK_in_CX_SI_ES_out_BX_const_DX_BP_DI_ES MACRO
    local check_loop

    xor BX, BX              ;; also clears carry
    shr CX, 1
    check_loop:
        seges
        lodsw
        adc BX, AX
    loop check_loop
    adc BX, 0               ;; add in the last carry if any
    not BX
ENDM




;;*****************************************************************************
;; ICMP_PACKET processes the ICMP packet that starts at BX:ES (this is the
;; start if the IP part of the packet
;;
ICMP_PACKET_in_BX_ES MACRO name
    local not_ping, done
    .errb <name>

    mov word ptr icmp_&name&_data.icmp_read_off, BX
    mov word ptr icmp_&name&_data.icmp_read_seg, ES
    mov word ptr icmp_&name&_data.icmp_read_len, CX
    mov SI, BX
    cmp byte ptr ES:[SI+icmp_type], ICMP_ECHO_REQUEST
    jnz not_ping
        IP_R_SRC_in_SI_ES_out_AX_BX_const_CX_DX_BP_SI_DI_ES %icmp_&name&_net
        mov DL, ICMP_PROTO
        IP_W_ACCESS_in_AX_BX_CX_DL_out_AX_DI_ES %icmp_&name&_net
        or AX, AX
        jnz done            ;; check return code
        
        mov DX, DS                                  ;; save DS
        mov CX, word ptr icmp_&name&_data.icmp_read_len
        lds SI, dword ptr icmp_&name&_data.icmp_read_off

        mov BX, CX                                  ;; save CX

        mov [SI+icmp_type], ICMP_ECHO_REPLY 
        mov AX, [SI+icmp_check]             ;; fix up ICMP checksum
        add AX, (ICMP_ECHO_REQUEST - ICMP_ECHO_REPLY) 
        adc AX, 0
        mov [SI+icmp_check], AX

        rep                                         ;; copy the ping
        movsb

        mov DS, DX                                  ;; restore DS
        mov CX, BX                                  ;; restore CX
        IP_W_WRITE_in_CX %icmp_&name&_net
        jmp done
    not_ping:
    done:
ENDM

