;;****************************************************************************
;;                      declare.inc         declare.inc
;;****************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;*****************************************************************************
;;
;; Due to limitations in TURBO ASSEMBLER, we have to compile PCroute in 
;; pieces.  declare.inc is a 'header' file that constains the declarations
;; of all compile-time information that is shared among seperately compiled
;; pieces.  
;;
;;  AUTHOR: Vance Morrison  
;;  DATE:   4/28/89  
;;****************************************************************************

    .MODEL SMALL

    JUMPS                       ;; deal with long jump displacements 
                                ;; automatically
    .CODE                       ;; extablish the default segment

    include debug.inc
    include log.inc
    include timer.inc
    include tasks.inc
    include buffer.inc
    include queue.inc
    include wd8003.inc
    include wd8003e.inc
    ;include bridge.inc
    include slip.inc
    include if.inc
    include ether.inc
    include arptab.inc
    include arp.inc
    ;include atalk.inc
    include dl_ip.inc
    include rip.inc
    include ip.inc
    include icmp.inc
    include udp.inc
    include bootp.inc 

    DB_DECLARE                  ;; declare debugging routines

    cur_dl = 1

    WDE_DECLARE %cur_dl, 280H, 0D000H, 00000H ;;<name>, <I/O>, <seg>, <off>
    IF_DECLARE %cur_dl, %cur_dl, WDE        ;; <if name>, <real if>, <prefix>
    ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task>
    ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
    DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
    cur_dl = cur_dl + 1

    WDE_DECLARE %cur_dl, 2A0H, 0D000H, 02000H ;;<name>, <I/O>, <seg>, <off>
    IF_DECLARE %cur_dl, %cur_dl, WDE        ;; <if name>, <real if>, <prefix>
    ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
    ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
    DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
    cur_dl = cur_dl + 1

 ;  WDE_DECLARE %cur_dl, 2C0H, 0D000H, 04000H ;;<name>, <I/O>, <seg>, <off>
 ;  IF_DECLARE %cur_dl, %cur_dl, WDE        ;; <if name>, <real if>, <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

 ;  WDE_DECLARE %cur_dl, 2E0H, 0D000H, 06000H ;;<name>, <I/O>, <seg>, <off>
 ;  IF_DECLARE %cur_dl, %cur_dl, WDE        ;; <if name>, <real if>, <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

    ;; this is a starlan entry, the only difference is in the first line
 ;  WD_DECLARE %cur_dl, 2A0H, 0D000H, 02000H,10,16 ;;<name>, <I/O>, <seg>, <off>
 ;  IF_DECLARE %cur_dl, %cur_dl, WD         ;; <if name>, <real if>, <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

    ;; this is a starlan entry, the only difference is in the first line
 ;  WD_DECLARE %cur_dl, 2C0H, 0D000H, 04000H,10,16 ;;<name>, <I/O>, <seg>, <off>
 ;  IF_DECLARE %cur_dl, %cur_dl, WD         ;; <if name>, <real if>, <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

        ;; localtalk interface
 ;  ATP_DECLARE %cur_dl, 5CH, %cur_dl, 10, 2000 ;; <name> <int> <task> <wqueue>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ATP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

 ;  ATP_DECLARE %cur_dl, 60H, %cur_dl, 10, 2000 ;; <name> <int> <task> <wqueue>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ATP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

        ;; SLIP interface
 ;  SLIP_DECLARE %cur_dl, %cur_dl, 1, 20, 10000 4, 3000 
 ;        ;; <name> <task> <port> <wqueue> <wbuff> <rqueue> <rbuff>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, SLIP    ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

 ;  SLIP_DECLARE %cur_dl, %cur_dl, 2, 20, 10000 4, 3000 
 ;                ;; <name> <task> <port> <wqueue> <wbuff> <rqueue> <rbuff>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, SLIP    ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

    num_dls = cur_dl - 1
    task_timer = cur_dl
    num_tasks  = cur_dl

    SCHED_DECLARE %num_tasks

    mytimer     = 10                        ;; WD_DECLARE Depends on this value
    TIMER_DECLARE %mytimer, %task_timer

    myip = 11
    myrip = 12
    myicmp = 13
    myudp = 14
    mybootp = 15
    mylog = 16
    dlog = 17
    IP_DECLARE %myip, %myrip, %num_dls, %myicmp
    UDP_DECLARE %myudp, %myip, %myicmp
    RIP_DECLARE %myrip, %myip, %mytimer, %myudp
    ICMP_DECLARE %myicmp, %myip, %myrip
    BOOTP_DECLARE %mybootp, %myudp, %num_dls
    LOG_DECLARE %mylog, LOG_LOCAL0, %myudp, %mytimer

