;;****************************************************************************
;;                     buffer.asm         buffer.asm
;;****************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;*************************************************************************
;;
;;  buffer.asm implements a simple buffer alocator for use in a packet 
;;  queue.
;;
;; AUTHOR: Vance Morrison
;; DATE:   5/24/89
;; ADDRESS: morrison@accuvax.nwu.edu
;;****************************************************************************

buff_data STRUC 
    start_free      DW          ;; free space between these
    end_free        DW          
buff_data ENDS 


;;**************************************************************************
;; buff declare declares a new buffer manager.  The buffer to be managed is
;; 'buff' of lenght 'len'
;;
BUFF_DECLARE MACRO name, buff, len

    .DATA
    buff_&name&_buff = buff 
    buff_&name&_len = len
    buff_&name&_buff_end = (buff + len)

    global buff_&name&_data:buff_data
    .CODE
ENDM

;;**************************************************************************
;; BUFF_DEFINE allocates memory and initializes the buffer manager
;;
BUFF_DEFINE MACRO name

    .DATA
    buff_&name&_data buff_data <>

    .CODE
    mov buff_&name&_data.start_free, offset buff_&name&_buff
    mov buff_&name&_data.end_free, offset buff_&name&_buff_end
ENDM


;;**************************************************************************
;; BUFF_CHECK checks to see if CX bytes of contiguous memory is available
;; in the buffer.  If it is it sets SI to the begining and DI to the end
;; of the buffer.  Othersize it jumps to 'fail'.  Note this routine does
;; NOT allocate the space (that is if BUFF_CHECK is called again it will
;; return the same space) BUFF_GET does the allocation
;;
BUFF_CHECK_in_CX_out_SI_DI_const_BX_CX_DX_BP_ES MACRO name, fail
    local done

    mov SI, word ptr buff_&name&_data.start_free
    mov AX, word ptr buff_&name&_data.end_free
    mov DI, SI
    add DI, CX                              ;; first guess at SI:DI output
    cmp DI, AX
    jbe done
        ;; try wrap around
        cmp SI, AX
        jbe fail

        cmp DI, offset buff_&name&_buff_end
        jbe done
            mov SI, offset buff_&name&_buff
            mov DI, SI
            add DI, CX                      ;; first guess at SI:DI output
            cmp DI, AX
            ja fail
    done:
ENDM


;;**************************************************************************
;; BUFF_GET allocates the space that was checked with BUFF_CHECK.  DI
;; is assumed to be initialized by BUFF_CHECK.
;;
BUFF_GET_in_DI_const_AX_BX_CX_DX_BP_SI_DI_ES MACRO name

    mov word ptr buff_&name&_data.start_free, DI
ENDM

;;**************************************************************************
;; BUFF_FREE releases the buffer allocated by BUFF_GET.  DI is assumed to
;; be the same value as returned by BUFF_CHECK.  IT ALSO RELEASES ALL 
;; ALLOCATION MADE PREVIOUSLY TO THE ALLOCATION ASSOCIATED WITH DI (that
;; is we asume that if Buffer 1 was allocated before Buffer 2, then 
;; buffer 1 will be freed before buffer 2. (this is true for queue allocations)
;;
BUFF_FREE_in_DI_const_AX_BX_CX_DX_BP_SI_DI_ES MACRO name
    local done

    mov word ptr buff_&name&_data.end_free, DI
    cmp DI, word ptr buff_&name&_data.start_free    ;; is the buffer all free?
    jnz done
        mov word ptr buff_&name&_data.start_free, offset buff_&name&_buff
        mov word ptr buff_&name&_data.end_free, offset buff_&name&_buff_end
    done:
ENDM

