/*
 * pfcopyall.c
 *
 * Print and modify the "pfcopyall" kernel
 *	pfcopyall [0 | 1]
 *
 */

#include <stdio.h>
#include <nlist.h>

#define	NAMELIST	"/vmunix"

#define	SYMNAME		"pfcopyall"
#define	FLAGSIZE	(sizeof(int))

int SetValue = 0;

main(argc, argv)
int argc;
char **argv;
{
	int kmem;
	int addr;
	char *progname = argv[0];
	unsigned int NewValue;
	unsigned int OldValue;

	if (argc == 1) {
	    SetValue = 0;
	}
	else if (argc == 2) {
	    SetValue = 1;
	    NewValue = atoi(argv[1]);
	    if (NewValue > 1)
		Usage(progname);
	}
	else {
	    Usage(progname);
	}

	if ((kmem = open("/dev/kmem", SetValue ? 2 : 0)) < 0) {
	    perror("/dev/kmem");
	    exit(1);
	}
	
	addr = SysName(SYMNAME);
	if (addr == -1) {
	    fprintf(stderr, "%s: %s not in symbol table\n", progname, SYMNAME);
	    exit(1);
	}

	if (lseek(kmem, addr, 0) != addr) {
	    perror("lseek");
	    exit(1);
	}
	
	if (read(kmem, &OldValue, FLAGSIZE) != FLAGSIZE) {
	    perror("read");
	    exit(1);
	}
	printf("%s:\n0x%x/\t%x", SYMNAME, addr, OldValue);

	if (!SetValue) {
	     printf("\n");
	     exit(0);
	}

	fflush(stdout);
	if (lseek(kmem, addr, 0) != addr) {
	    perror("lseek");
	    exit(1);
	}
	
	if (write(kmem, &NewValue, FLAGSIZE) != FLAGSIZE) {
	    printf("\n");
	    fflush(stdout);
	    perror("write");
	    exit(1);
	}

	if (lseek(kmem, addr, 0) != addr) {
	    perror("lseek");
	    exit(1);
	}
	if (read(kmem, &OldValue, FLAGSIZE) != FLAGSIZE) {
	    perror("read");
	    exit(1);
	}
	printf("\t = %x\n", OldValue);
}

Usage(progname)
char *progname;
{
	fprintf(stderr, "Usage:\n");
	fprintf(stderr, "%s [0|1]\n", progname);
	exit(1);
}

SysName(name)
char *name;
{
	int addr;
	struct nlist nl[2];
	char *_name;
	char *malloc();

	bzero(nl, sizeof(nl));

	_name = malloc(strlen(name) + 2);
	sprintf(_name, "_%s", name);

	nl[0].n_name = _name;
	nlist(NAMELIST, nl);
	if (nl[0].n_value == 0)
	    return(-1);
	else
	    return(nl[0].n_value);
}
