/*
 * $Header: /tmp_mnt/net/sparky.a/davy/system/nfswatch/RCS/externs.h,v 1.2 90/08/17 15:46:43 davy Exp $
 *
 * externs.h - external definitons for nfswatch.
 *
 * David A. Curry
 * SRI International
 * 333 Ravenswood Avenue
 * Menlo Park, CA 94025
 * davy@itstd.sri.com
 *
 * $Log:	externs.h,v $
 * Revision 1.2  90/08/17  15:46:43  davy
 * NFSWATCH Version 2.0.
 * 
 * Revision 1.1  88/11/29  11:20:27  davy
 * NFSWATCH Release 1.0
 * 
 */

extern char		*pname;

extern FILE		*logfp;

extern Counter		pkt_total;
extern Counter		pkt_drops;
extern Counter		int_pkt_total;
extern Counter		int_pkt_drops;
extern Counter		dst_pkt_total;
extern Counter		int_dst_pkt_total;

extern int		errno;
extern int		if_fd;
extern int		dstflag;
extern int		srcflag;
extern int		allflag;
extern int		logging;
extern int		learnfs;
extern int		do_update;
extern int		cycletime;
extern int		showwhich;
extern int		truncation;
extern int		sortbyusage;
extern int		nnfscounters;
extern int		nfilecounters;
extern int		screen_inited;

extern u_long		thisdst;
extern u_long		srcaddrs[];
extern u_long		dstaddrs[];

extern struct timeval	starttime;

extern char		myhost[];
extern char		srchost[];
extern char		dsthost[];

extern char		*prompt;
extern char		*logfile;
extern char		*filelist;
extern char		*snapshotfile;

extern NFSCounter	nfs_counters[];
extern FileCounter	fil_counters[];
extern PacketCounter	pkt_counters[];

char			*prtime();
char			*savestr();

int			fil_comp();
int			is_exported();
int			nfs_comp();
int			udprpc_recv();
int			want_packet();

void			clear_vars();
void			command();
void			error();
void			finish();
void			flush_nit();
void			get_net_addrs();
void			icmp_filter();
void			ip_filter();
void			label_screen();
void			nd_filter();
void			nfs_count();
void			nfs_filter();
void			nfswatch();
void			pkt_filter();
void			rpc_callfilter();
void			rpc_filter();
void			rpc_replyfilter();
void			setup_fil_counters();
void			setup_nfs_counters();
void			setup_nit_dev();
void			setup_pkt_counters();
void			setup_screen();
void			setup_rpcxdr();
void			snapshot();
void			sort_nfs_counters();
void			tcp_filter();
void			udp_filter();
void			update_logfile();
void			update_screen();
void			usage();
void			wakeup();
