#include "notify.h"
#include <utmp.h>
#include <sys/file.h>
#include <win.h>
#include <pen.h>
#include <signal.h>
#include <icon.h>
#include <pen.h>
#include <rfont.h>

static int  panel;
static  RSize posn, ipos;
static  RSize size;
static  Raster * raster;
static  Window * window;
static  Pen * pen;
static  Raster * RasterCreate ();
static  Window * WinCreate ();
static  Pen * PenCreate ();
static  IconList *iconlist;
void pdIconWriteLabels();

int pageno = 0;
int stopit();

#define UTMP "/etc/utmp"

int my_socket = 0;
notify data;
int debug = 0;
char *progname;
FILE *out;

main(argc,argv)
int argc;
char *argv[];
{
	int c,fromlen;
	struct sockaddr_in from;

	out = stdout;
	progname = argv[0];
	c = recvfrom(my_socket, &data, sizeof(notify), 0, 
		(struct sockaddr *) &from, &fromlen);
	if(fork() >0) exit(0);
	if(debug)
		fprintf(out,"RECVD to %s data %s ID %s type %d size %d\n",
			data.to, data.mess, data.id, data.type, c);
	if (c != sizeof(notify)) exit(0);
	if(debug)
		fprintf(out,"Size OK\n");
	if(!strcmp(data.id,"notify")) show(data);
	if(debug)
		fprintf(out,"Showed data OK\n");
	exit (0);
}

show(data)
notify data;
{
	int fd, showit=0;
	FILE *fp;
	struct utmp entry;
	char tty[20];

	fd = open(UTMP,O_RDONLY,NULL);
	if (fd < 0) return;
	while (read(fd, &entry, sizeof(struct utmp)) > 0) {
		if ((data.type == MACHINE_WIDE) ||
		    (data.type == MACH_AND_WIN) ||
		    (!strncmp(data.to,entry.ut_name,8))) {
			strcpy(tty,"/dev/");
			if (strncmp("tty",entry.ut_line,3)) continue;
			if (*entry.ut_name == '\0') continue;
			if (((data.type == WINDOWED)||
			   (data.type == MACH_AND_WIN)) &&
			   (entry.ut_line[3]=='v')) {
			   	showit++;
			   	continue;
			   }
			strncat(tty,entry.ut_line,8);
			fp = fopen(tty,"w");
			if (debug) fprintf(out,"Trying %s\n",tty);
			if (fp == NULL) continue;
			fprintf(fp,"%s",data.mess);
			fclose(fp);
		}
	}
	close(fd);

	if(showit) {
		MGblast(data.mess, data.from);
	}
}

MGblast(buf,from)
char *buf, *from;
{
	int i=0,j;
	int lineno = 10;
	Event event;

	show_page(pageno,from,buf);
	at(5,lineno);
	for (j=0;j<strlen(buf);j++) {
		if((++i % 115) == 0 || (buf[j] == '\n')) {
		    at(5,lineno);
		    lineno += 10;
		    i = 1;
		}
		else if ((buf[j] > 31) && (buf[j] < 128)) 
			writech(buf[j]);
	} 
	page_update();
        signal(SIGALRM,stopit);
	alarm(600);	/* 10 minutes */
	PanelRead(panel,&event,1);
}


show_page (pos,sentfrom,mess)
int pos;
char *sentfrom, *mess;
{
    int i;
    char iconname[80];
    posn.w = 160;
    posn.h = 300;
    size.w = 700;
    size.h = 10*linecount(mess)+5;
    if(size.h <40) size.h = 40;
    ipos.w = 980;
    ipos.h = 0;
    raster = RasterCreate (size.w, size.h, 0, R_PIXD (1));
    pen = PenCreate (raster);
    strcpy(iconname,sentfrom);
    strcat(iconname,".icn");
    iconlist = (IconList *)IconListRead(iconname,NULL);
    if(iconlist == NULL) 
	iconlist = (IconList *)IconListRead("not.icn",NULL);
    pdIconWriteLabels(iconlist,sentfrom);
    window = WinCreate (&posn, &size, 0, &ipos, NULL, 1, iconlist,
	    sentfrom, NULL, W_FULL_TYPE);
    panel = WinGetPanel (window);
    PanelSetMask(panel,E_CLICK_CLASS | E_SEL_CLASS);
    PageDefine (panel, 0, raster, NULL, NULL);
    PageSelect (panel, 0);
    PanelUpdate (panel, 0, 1);
    WinDisplay (window);
}

kill_page () {
    WinDestroy (window);
    PenDestroy (pen);
    RasterDestroy (raster);
}

writech(c) char c;
{
	TextWritef(pen,"%c",c);
}


page_update () {
    PanelUpdate(panel,0,1);
    ipos.w = 0;
    IconSetPosition(WinGetID(window), &ipos); 
    ipos.h = 760;
    IconSetPosition(WinGetID(window), &ipos); 
    ipos.w = 980;
    IconSetPosition(WinGetID(window), &ipos); 
    ipos.h = 0;
    IconSetPosition(WinGetID(window), &ipos); 
    IconShow(WinGetID(window));    
    WindowUnstow(WinGetID(window));
}

at (x, y)
int     x,
	y;
{
    PenSetXY (pen, x, y);
}

int linecount(s)
char *s;
{ int lines=0;
  while(*s != NULL) 
	if(*(s++) == '\n') lines++;
  return lines;
}

int stopit()
{
	exit(0);
}

static Pen	*mypen = 0;

void pdIconWriteLabels (ilist, label)
    IconList		*ilist;
    char		*label;
{
    register Icon	*ip = ilist->Icons;
    int			i;
    RFont *font;

    if (!mypen)
	mypen = PenCreate (ip->Image);
    font = (RFont *)FontAcquire("stdicon","i",8);
    PenSetFont(mypen,font);

    for (i = ilist->Count; i != 0; i--, ip++) {
	PenSetSheet (mypen, ip->Image);

        if (ip->TextBox.size.w != 0 && ip->TextBox.size.h != 0) {
	    PenSetPos (mypen, &ip->TextBox.pos);
	    TextCentreStr (mypen, label, &ip->TextBox.size);
	}
    }
}
