#include "notify.h"
#include <utmp.h>
#include <sys/file.h>

#define UTMP "/etc/utmp"

int my_socket = 0;	/* inetd gives us fd 0 */
notify data;
int debug = 0;		/* set to 1 for debug output on fp 'out' */
char *progname;
FILE *out;

main(argc,argv)
int argc;
char *argv[];
{
	int c,fromlen;
	struct sockaddr_in from;
	out = stderr;	/* or fopen ("/dev/console","w"); */
	progname = argv[0];
	c = recvfrom(my_socket, &data, sizeof(notify), 0, 
		(struct sockaddr *) &from, &fromlen);
	if(debug)
		fprintf(out,"RECVD to %s data %s ID %s type %d size %d\n",
			data.to, data.mess, data.id, data.type, c);
	if (c != sizeof(notify)) exit(0);
	if(debug)
		fprintf(out,"Size OK\n");
	if(!strcmp(data.id,"notify")) show(data);
	if(debug)
		fprintf(out,"Showed data OK\n");
	exit (0);
}

show(data)	/* this version ignores the windowing options */
notify data;
{
	int fd;
	FILE *fp;
	struct utmp entry;
	char tty[20];

	fd = open(UTMP,O_RDONLY,NULL);
	if (fd < 0) return;
	while (read(fd, &entry, sizeof(struct utmp)) > 0) {
		if ((data.type == MACHINE_WIDE) ||
		   (data.type == MACH_AND_WIN)||
		   (!strncmp(data.to,entry.ut_name,8))) {
			strcpy(tty,"/dev/");
			if (strncmp("tty",entry.ut_line,3)) continue;
			if (*entry.ut_name == '\0') continue;
			strncat(tty,entry.ut_line,8);
			fp = fopen(tty,"w");
			if (debug) fprintf(out,"Trying %s\n",tty);
			if (fp == NULL) continue;
			fprintf(fp,"%s",data.mess);
			fclose(fp);
		}
	}
	close(fd);
}
