#include "notify.h"
#include <netdb.h>

int my_socket;
struct sockaddr_in my_address;
struct sockaddr_in all;         /* broadcast address */

extern char *progname;
extern int debug;

init_socket(trigger,rhost)
int trigger;
char *rhost;
{
    char host[128];
    char *service_name;
    long host_net;
    struct in_addr *host_addr, *tohost_addr;

    struct hostent *hp, *tohp;
    struct servent *sp;
    int bound;

    my_socket = socket(AF_INET, SOCK_DGRAM, 0, 0);
    if (my_socket < 0) {
	perror(progname);
	exit(-1);
    }

    /* Get any old local port and the local address */

    my_address.sin_addr.s_addr = INADDR_ANY;
    my_address.sin_port        = 0;

    bound = bind(my_socket, &my_address, sizeof(my_address), 0);
    if (bound < 0) {
	perror(progname);
	exit(-1);
    }

    /* Now create the broadcast address with the well known
     * port number - use a different number according to the
     * value of "trigger".
     */

    gethostname(host, sizeof(host));

    hp = gethostbyname(host);
    if (hp == NULL) {
	fprintf(stderr,"%s: couldn't get hostent ", progname);
	perror(host);
    }
    tohp = gethostbyname(rhost);
    if (tohp == NULL) {
	fprintf(stderr,"%s: couldn't get hostent ", progname);
	perror(rhost);
    }

    host_addr = (struct in_addr *) hp->h_addr;
    host_net  = inet_netof(host_addr->s_addr);

    tohost_addr = (struct in_addr *) tohp->h_addr;

    service_name = SERVICE_NAME;
    sp = getservbyname(service_name, "udp");
    if (sp == NULL) {
	perror(progname);
    }

    all.sin_family  = AF_INET;
    all.sin_addr    = *(struct in_addr *)(tohp -> h_addr);
    all.sin_port    = sp->s_port;

    if (debug) {
	printf("Broadcast address = (%08x) = %s, %d (family %d)\n",
	    all.sin_addr.s_addr,
	    inet_ntoa(all.sin_addr),
	    htons(all.sin_port),
	    all.sin_family);
    }
}
