#include "notify.h"
#include <pwd.h>
#include <protocols/rwhod.h>
#include <sys/dir.h>
#include <sys/time.h>

notify data;
int debug = 0, verbose=0, windowed=0;
char *progname;
int listlen;
char hostlist[500][32];
int silent=0, broadcast=0;

struct whod wd;

#define WHDRSIZE (sizeof(wd) - sizeof(wd.wd_we))
#define RWHODIR  "/usr/spool/rwho"

extern int my_socket;
extern struct sockaddr_in all;

main(argc,argv)
int argc;
char *argv[];
{
	int i,j;
	int c,pid;
	char *p = data.mess;
	char host[32];
	struct passwd *entry = getpwuid(getuid());
	struct tm *loctime;
	struct timeval tp;

	progname = argv[0];
	if (argc <2) {
		fprintf(stderr, "Usage: %s [-m][-s][-w] user/machine [user ..]\n",argv[0]);
		exit(1);
	}
	strncpy(data.from,entry->pw_name,8);
	for (i=1;i<argc;i++) {
		if(!strcmp(argv[i],"-s")) 
			silent++;
		else if (!strcmp(argv[i],"-m"))
			broadcast++;
		else if (!strcmp(argv[i],"-v"))
			verbose++;
		else if (!strcmp(argv[i],"-w"))
			windowed++;
		else if (!strncmp(argv[i],"-o",2))
			strncpy(data.from,&argv[i][2],8);
	}
	if (*data.from == '\0') strcpy(data.from, "anon");
	
	if(broadcast && !windowed) data.type = MACHINE_WIDE;
	else if(windowed && !broadcast) data.type = WINDOWED;
	else if(windowed && broadcast) data.type = MACH_AND_WIN;
	else data.type = PERSON_ONLY;

	gettimeofday(&tp, (struct timezone *)NULL);
	loctime = localtime(&tp);
		
	if(!silent) {
		gethostname(host,32);
		sprintf(data.mess,"\n\rMessage from %.8s@%s [%02d:%02d]... \n\r\n\r%c",
			data.from,host,loctime->tm_hour,loctime->tm_min,7);
		p = &data.mess[strlen(data.mess)];
	}
	while((c=getc(stdin)) != EOF) {
		*p++ = c;
		if (c == '\n') *p++ = '\r';
		if((p - data.mess) >= MESS_SIZE) {
			fprintf(stderr,"%s: message too long\n",argv[0]);
			exit(1);
		}
		if (!strncmp((p-5),"\n\r.\n\r",5)) { 
			fclose (stdin);
			p -= 3;
		}
	}
	*p = NULL;
	if (debug) printf("Data is %s\n",data.mess);

	if(!verbose) {	
		while ((pid=fork()) < 0) sleep(5);
		if (pid) exit(0);		/* fork child to save delays */
	}

	strcpy(data.id,"notify");

	if (verbose && broadcast) 
		printf("Broadcasting to");
	for(i=1;i<argc;i++) {
		listlen=0;
		if (*argv[i]=='-') continue;
		if (!broadcast) {
			makehostlist(argv[i]);
			strncpy(data.to, argv[i], 8);
			if (verbose)
				printf("For %s writing to machines",argv[i]);
			for(j=0;j<listlen;j++) {
				init_socket(0,hostlist[j]);
				if (verbose) {
					printf(" %s",hostlist[j]);
					fflush(stdout);
				}
				sendto(my_socket, &data, sizeof(notify),0,
					&all, sizeof(all));
			}
		} else {
			if (verbose) {
				printf(" %s",argv[i]);
				fflush(stdout);
			}
			init_socket(0,argv[i]);
			strcpy(data.to,"nobody");
			sendto(my_socket, &data, sizeof(notify),0,
				&all, sizeof(all));
		}
		if (!broadcast && verbose) printf(".\n");
		if (debug)
			printf("TO %s ID %s MESS %s\n",data.to, data.id,
				data.mess);
		close(my_socket);
	}
	if (verbose && broadcast) printf(".\n");
}

makehostlist(name)
char *name;
{
	int i,cc,f,n;
	DIR *rwhodir;
	struct direct *dp;
	register struct whod *w = &wd;
	register struct whoent *we;

	if(chdir(RWHODIR) <0) {
		perror(RWHODIR);
		exit(1);
	}
	rwhodir = opendir(".");
	if (rwhodir == NULL) {
		perror(RWHODIR);
		exit(1);
	}

	listlen=0;
	while (dp=readdir(rwhodir)) {
		if(dp->d_ino == 0)
			continue;
		if(strncmp(dp->d_name,"whod.",5))
			continue;
		f = open(dp->d_name,0);
		if (f < 0) continue;
		cc = read(f,(char *)&wd,sizeof(struct whod));
		if (cc < WHDRSIZE) {
			close(f);
			continue;
		}
		we = w->wd_we;
		cc -= WHDRSIZE;
		for(n=cc/sizeof(struct whoent); n>0; n--) {
			if(!strncmp(we->we_utmp.out_name,name,8)) {
				addtolist(w->wd_hostname);
				break;
			}
			we++;
		}
		close(f);
	}
	closedir(rwhodir);
}

addtolist(host)
char *host;
{
	register int i;
	for(i=0;i<listlen;i++)
		if(!strcmp(host,hostlist[i])) return;
	strcpy(hostlist[listlen++],host);
}
