#include <netdb.h>
#include <errno.h>
#include <signal.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <xdr.h>
#include <rpc.h>

#include <htable.h>
#include <malloc.h>

extern int errno;

#define PMAP_PROGRAM 100000
#define PMAP_VERSION 2

typedef struct {
	  int program;
	  int version;
	  int udpport;
	  int tcpport; } MAPPING;

typedef struct {
	  int i1;
	  int i2;
	  int i3;
	  int i4; } FOURINTS;

char pmap_service[] = "sunrpc";
char packet[10240];
int packetlen;
char reply[10240];
char *mappings;
int pmap_sock;
RPC_MSG req;
struct sockaddr_in from;
RPC_MSG rep;
int shoulddie;
int lastkillsig;

int map_hash(mapcp,tblsiz)
char *mapcp;
int tblsiz;
{
 register MAPPING *mp;
 register unsigned int ui;

 mp = (MAPPING *) mapcp;
 ui = (mp->program * 0x31) + (mp->version * 0x301);
 ui &= (~(unsigned int)0) >> 1;
 ui %= (unsigned int) tblsiz;
 return((int)ui);
}

int map_cmp(mcp1,mcp2)
char *mcp1;
char *mcp2;
{
 register MAPPING *mp1;
 register MAPPING *mp2;

 mp1 = (MAPPING *) mcp1;
 mp2 = (MAPPING *) mcp2;
 return( (mp1->program != mp2->program) ||
	 (mp1->version != mp2->version) );
}

bool_t xdr_4ints(x,fi)
XDR *x;
FOURINTS *fi;
{
 return( xdr_int(x,&fi->i1) &&
	 xdr_int(x,&fi->i2) &&
	 xdr_int(x,&fi->i3) &&
	 xdr_int(x,&fi->i4) );
}

killsig(sig)
int sig;
{
 lastkillsig = sig;
 shoulddie ++;
}

main()
{
 struct sockaddr_in sin;
 int sinlen;
 struct servent *sp;
 int i;

 openlog("pmapd",LOG_PID|LOG_CONS,LOG_DAEMON);
 i = fork();
 if (i < 0)
  { perror("fork");
  }
 if (i)
  { exit(0);
  }
 i = open("/dev/tty",O_RDWR,0);
 if (i >= 0)
  { ioctl(i,TIOCNOTTY,0);
    close(i);
  }
 mappings = new_htable(map_hash,map_cmp);
 pmap_set(PMAP_PROGRAM,PMAP_VERSION,IPPROTO_UDP,ntohs(sp->s_port));
 pmap_sock = socket(AF_INET,SOCK_DGRAM,0);
 if (pmap_sock < 0)
  { syslog(LOG_ERR,"can't create socket: %m");
    exit(1);
  }
 sp = getservbyname(pmap_service,"udp");
 if (sp == 0)
  { syslog(LOG_ERR,"%s/udp service unknown",pmap_service);
    exit(1);
  }
 sin.sin_family = AF_INET;
 sin.sin_addr.s_addr = INADDR_ANY;
 sin.sin_port = sp->s_port;
 if (bind(pmap_sock,(char *)&sin,sizeof(sin)) < 0)
  { syslog(LOG_ERR,"can't bind socket to port %d: %m",ntohs(sin.sin_port));
    exit(1);
  }
 sinlen = sizeof(sin);
 if (getsockname(pmap_sock,(char *)&sin,&sinlen) < 0)
  { syslog(LOG_ERR,"can't get socket address: %m");
    exit(1);
  }
 shoulddie = 0;
 signal(SIGHUP,killsig);
 signal(SIGINT,killsig);
 signal(SIGTERM,killsig);
 signal(SIGTSTP,killsig);
 signal(SIGTTIN,killsig);
 signal(SIGTTOU,killsig);
 signal(SIGXCPU,killsig);
 signal(SIGXFSZ,killsig);
  { long int now;
    time(&now);
    syslog(LOG_INFO,"startup %.24s",ctime(&now));
  }
 i = 0;
 while (1)
  { if (shoulddie)
     { goto die;
     }
    sinlen = sizeof(sin);
    packetlen = recvfrom(pmap_sock,packet,sizeof(packet),0,(char *)&sin,&sinlen);
    if (packetlen < 0)
     { if (errno == EINTR)
	{ continue;
	}
       syslog(LOG_ERR,"error in recvfrom(): %m");
badpacket:
       i ++;
       if (i > 10)
	{ exit(1);
	}
       sleep(2);
       continue;
     }
    if (packetlen == 0)
     { syslog(LOG_WARNING,"zero-size input packet");
       goto badpacket;
     }
    if (sinlen != sizeof(sin))
     { syslog(LOG_WARNING,"bad from-address size (%d bytes)",sinlen);
       goto badpacket;
     }
    i -= 4;
    if (i < 0)
     { i = 0;
     }
    from = sin;
    inputpacket(packet,packetlen);
  }
die:
 syslog(LOG_INFO,"dying: received signal %d",lastkillsig);
 exit(0);
}

int pmap_set(pgm,vers,proto,port)
int pgm;
int vers;
int proto;
int port;
{
 MAPPING *mp;
 MAPPING *old;
 int *portp;

 mp = NEW(MAPPING);
 mp->program = pgm;
 mp->version = vers;
 mp->udpport = 0;
 mp->tcpport = 0;
 old = (MAPPING *) add_hentry(mappings,(char *)mp);
 if (old)
  { OLD(mp);
    mp = old;
  }
 switch (proto)
  { case IPPROTO_UDP:
       portp = &mp->udpport;
       break;
    case IPPROTO_TCP:
       portp = &mp->tcpport;
       break;
    default:
       return(0);
       break;
  }
 if (*portp)
  { return(0);
  }
 *portp = port;
 return(1);
}

int pmap_unset(pgm,vers)
int pgm;
int vers;
{
 MAPPING m;
 MAPPING *mp;

 m.program = pgm;
 m.version = vers;
 mp = (MAPPING *) del_hentry(mappings,(char *)&m);
 if (mp)
  { OLD(mp);
    return(1);
  }
 return(0);
}

unsigned int pmap_getport(pgm,vers,proto)
int pgm;
int vers;
int proto;
{
 MAPPING m;
 MAPPING *mp;

 m.program = pgm;
 m.version = vers;
 mp = (MAPPING *) find_hentry(mappings,(char *)&m);
 if (! mp)
  { return(0);
  }
 switch (proto)
  { case IPPROTO_UDP:
       return(mp->udpport);
       break;
    case IPPROTO_TCP:
       return(mp->tcpport);
       break;
    default:
       return(0);
       break;
  }
}

inputpacket(pkt,len)
char *pkt;
int len;
{
 XDR x;

 xdrmem_create(&x,pkt,len,XDR_DECODE);
 if (! xdr_rpc_msg(&x,&req))
  { syslog(LOG_WARNING,"XDR failed on input packet from %s/%d",
			inet_ntoa(from.sin_addr),ntohs(from.sin_port));
    goto out;
  }
 rep.xid = req.xid;
 rep.type = REPLY;
 if (req.type != CALL)
  { syslog(LOG_INFO,"non-call packet from %s/%d",
			inet_ntoa(from.sin_addr),ntohs(from.sin_port));
    goto out;
  }
 if (req.u.call.rpcvers != 2)
  { syslog(LOG_WARNING,"bad RPC version (%d) from %s/%d",
	req.u.call.rpcvers,inet_ntoa(from.sin_addr),ntohs(from.sin_port));
    rpc_mismatch();
    goto out;
  }
 if (req.u.call.prog != PMAP_PROGRAM)
  { syslog(LOG_WARNING,"non-pmap packet (program %d) from %s/%d",
	req.u.call.prog,inet_ntoa(from.sin_addr),ntohs(from.sin_port));
    goto out;
  }
 if (req.u.call.vers != PMAP_VERSION)
  { syslog(LOG_WARNING,"bad pmap version (%d) from %s/%d",
	req.u.call.vers,inet_ntoa(from.sin_addr),ntohs(from.sin_port));
    vers_mismatch();
    goto out;
  }
 switch (req.u.call.proc)
  { case 0:
       msg_null(&x);
       break;
    case 1:
       msg_set(&x);
       break;
    case 2:
       msg_unset(&x);
       break;
    case 3:
       msg_getport(&x);
       break;
    case 4:
       msg_dump(&x);
       break;
    case 5:
       msg_callit(&x);
       break;
    default:
       badproc();
       break;
  }
out:
 xdr_destroy(&x);
 return;
}

sendreply(xextra,extraarg)
bool_t (*xextra)();
char *extraarg;
{
 XDR x;
 int len;
 int sent;

 xdrmem_create(&x,reply,sizeof(reply),XDR_ENCODE);
 if (xdr_rpc_msg(&x,&rep) && (*xextra)(&x,extraarg))
  { len = xdr_getpos(&x);
    sent = sendto(pmap_sock,reply,len,0,&from,sizeof(struct sockaddr_in));
    if (sent < 0)
     { syslog(LOG_ERR,"can't return message to %s/%d: %m",
			inet_ntoa(from.sin_addr),ntohs(from.sin_port));
     }
    else if (sent != len)
     { syslog(LOG_WARNING,"sendto sent %d not %d",sent,len);
     }
  }
 else
  { syslog(LOG_ERR,"XDR can't encode return message");
  }
 xdr_destroy(&x);
}

rpc_mismatch()
{
 rep.u.reply.type = MSG_DENIED;
 rep.u.reply.u.denied.type = RPC_MISMATCH;
 rep.u.reply.u.denied.u.mismatch.low = 2;
 rep.u.reply.u.denied.u.mismatch.high = 2;
 sendreply(xdr_void,(char *)0);
}

vers_mismatch()
{
 rep.u.reply.type = MSG_ACCEPTED;
 rep.u.reply.u.accepted.verf.type = AUTH_NULL;
 rep.u.reply.u.accepted.verf.len = 0;
 rep.u.reply.u.accepted.type = PROG_MISMATCH;
 rep.u.reply.u.accepted.u.mismatch.low = PMAP_VERSION;
 rep.u.reply.u.accepted.u.mismatch.high = PMAP_VERSION;
 sendreply(xdr_void,(char *)0);
}

badproc()
{
 rep.u.reply.type = MSG_ACCEPTED;
 rep.u.reply.u.accepted.verf.type = AUTH_NULL;
 rep.u.reply.u.accepted.verf.len = 0;
 rep.u.reply.u.accepted.type = PROC_UNAVAIL;
 sendreply(xdr_void,(char *)0);
}

garbage_args()
{
 rep.u.reply.type = MSG_ACCEPTED;
 rep.u.reply.u.accepted.verf.type = AUTH_NULL;
 rep.u.reply.u.accepted.verf.len = 0;
 rep.u.reply.u.accepted.type = GARBAGE_ARGS;
 sendreply(xdr_void,(char *)0);
}

success(xextra,extraarg)
bool_t (*xextra)();
char *extraarg;
{
 rep.u.reply.type = MSG_ACCEPTED;
 rep.u.reply.u.accepted.verf.type = AUTH_NULL;
 rep.u.reply.u.accepted.verf.len = 0;
 rep.u.reply.u.accepted.type = SUCCESS;
 sendreply(xextra,extraarg);
}

msg_null(x)
XDR *x;
{
 success(xdr_void,(char *)0);
}

msg_set(x)
XDR *x;
{
 FOURINTS fi;
 bool_t rv;

 if (! xdr_4ints(x,&fi))
  { garbage_args();
    return;
  }
 rv = pmap_set(fi.i1,fi.i2,fi.i3,fi.i4) ? TRUE : FALSE;
 success(xdr_bool,(char *)&rv);
}

msg_unset(x)
XDR *x;
{
 FOURINTS fi;
 bool_t rv;

 if (! xdr_4ints(x,&fi))
  { garbage_args();
    return;
  }
 rv = pmap_unset(fi.i1,fi.i2) ? TRUE : FALSE;
 success(xdr_bool,(char *)&rv);
}

msg_getport(x)
XDR *x;
{
 FOURINTS fi;
 unsigned int rv;

 if (! xdr_4ints(x,&fi))
  { garbage_args();
    return;
  }
 rv = pmap_getport(fi.i1,fi.i2,fi.i3);
 success(xdr_u_int,(char *)&rv);
}

msg_dump(x)
XDR *x;
{
 badproc();
}

msg_callit(x)
XDR *x;
{
 badproc();
}
