#include <xdr.h>
#include <nfs.h>

bool_t xdr_fhandle(x,fhp)
XDR *x;
FHANDLE *fhp;
{
 return(xdr_opaque(x,&fhp->bytes[0],FHSIZE));
}

bool_t xdr_fattr(x,fap)
XDR *x;
FATTR *fap;
{
 return( xdr_enum(x,&fap->type) &&
	 xdr_u_int(x,&fap->mode) &&
	 xdr_u_int(x,&fap->nlink) &&
	 xdr_u_int(x,&fap->uid) &&
	 xdr_u_int(x,&fap->gid) &&
	 xdr_u_int(x,&fap->size) &&
	 xdr_u_int(x,&fap->blocksize) &&
	 xdr_u_int(x,&fap->rdev) &&
	 xdr_u_int(x,&fap->blocks) &&
	 xdr_u_int(x,&fap->fsid) &&
	 xdr_u_int(x,&fap->fileid) &&
	 xdr_struct_timeval(x,&fap->atime) &&
	 xdr_struct_timeval(x,&fap->mtime) &&
	 xdr_struct_timeval(x,&fap->ctime) );
}

bool_t xdr_sattr(x,sap)
XDR *x;
SATTR *sap;
{
 /* Bug workaround: Other NFS implementations tend to send 65535	 */
 /*  instead of -1 in unused fields....					 */
 if (!( xdr_u_int(x,&sap->mode) &&
	xdr_u_int(x,&sap->uid) &&
	xdr_u_int(x,&sap->gid) ))
  { return(0);
  }
 if (sap->mode == (unsigned int)(unsigned short int)-1)
  { sap->mode = -1;
  }
 if (sap->uid == (unsigned int)(unsigned short int)-1)
  { sap->uid = -1;
  }
 if (sap->gid == (unsigned int)(unsigned short int)-1)
  { sap->gid = -1;
  }
 return( xdr_u_int(x,&sap->size) &&
	 xdr_struct_timeval(x,&sap->atime) &&
	 xdr_struct_timeval(x,&sap->mtime) );
}

bool_t xdr_filename(x,fnp)
XDR *x;
FILENAME *fnp;
{
 char *np;

 if (x->x_op == XDR_FREE)
  { return(TRUE);
  }
 np = &fnp->name[0];
 return(xdr_bytes(x,&np,&fnp->len,MAXNAMLEN));
}

bool_t xdr_path(x,pp)
XDR *x;
PATH *pp;
{
 char *cp;

 if (x->x_op == XDR_FREE)
  { return(TRUE);
  }
 cp = &pp->path[0];
 return(xdr_bytes(x,&cp,&pp->len,MAXPATHLEN));
}

bool_t xdr_attrstat(x,asp)
XDR *x;
ATTRSTAT *asp;
{
 static XDR_DISCRIM asxd[] = { { NFS_OK, xdr_fattr },
			       { __dontcare__, 0 } };

 return(xdr_union(x,&asp->status,(char *)&asp->u,asxd,xdr_void));
}

bool_t xdr_diropargs(x,dop)
XDR *x;
DIROPARGS *dop;
{
 return(xdr_fhandle(x,&dop->dir) && xdr_filename(x,&dop->name));
}

static bool_t xdr__diropres(x,dorop)
XDR *x;
struct _diropresok *dorop;
{
 return(xdr_fhandle(x,&dorop->file) && xdr_fattr(x,&dorop->attributes));
}

bool_t xdr_diropres(x,dop)
XDR *x;
DIROPRES *dop;
{
 static XDR_DISCRIM doxd[] = { { NFS_OK, xdr__diropres },
			       { __dontcare__, 0 } };

 return(xdr_union(x,&dop->status,(char *)&dop->u,doxd,xdr_void));
}

bool_t xdr_cookie(x,ckp)
XDR *x;
COOKIE *ckp;
{
 return(xdr_opaque(x,&ckp->bytes[0],COOKIESIZE));
}

bool_t xdr_fhstatus(x,fhp)
XDR *x;
FHSTATUS *fhp;
{
 if (! xdr_u_int(x,&fhp->status))
  { return(FALSE);
  }
 if (fhp->status != 0)
  { return(TRUE);
  }
 return(xdr_fhandle(x,&fhp->u.directory));
}

bool_t xdr_dirpath(x,dpp)
XDR *x;
DIRPATH *dpp;
{
 char *cp;

 if (x->x_op == XDR_FREE)
  { return(TRUE);
  }
 cp = &dpp->path[0];
 return(xdr_bytes(x,&cp,&dpp->len,MNTPATHLEN));
}

bool_t xdr_name(x,np)
XDR *x;
NAME *np;
{
 char *cp;

 if (x->x_op == XDR_FREE)
  { return(TRUE);
  }
 cp = &np->name[0];
 return(xdr_bytes(x,&cp,&np->len,MNTNAMLEN));
}
