#define RPCERR_NONE 0
#define RPCERR_RPCMISMATCH 1
#define RPCERR_BADCRED 2
#define RPCERR_REJECTEDCRED 3
#define RPCERR_BADVERF 4
#define RPCERR_REJECTEDVERF 5
#define RPCERR_TOOWEAK 6
#define RPCERR_PROGMISMATCH 7
#define RPCERR_PROGUNAVAIL 8
#define RPCERR_PROCUNAVAIL 9
#define RPCERR_GARBAGEARGS 10
#define RPCERR_GARBAGEREPLY 11
#define RPCERR_TIMEDOUT 12

/* auth_flavor */
#define AUTH_NULL 0
#define AUTH_UNIX 1
#define AUTH_SHORT 2

struct opaque_auth {
  enum_t type;
  unsigned int len;
  char body[400]; } ;

typedef struct opaque_auth OPAQUE_AUTH;

/* msg_type */
#define CALL 0
#define REPLY 1

/* reply_stat */
#define MSG_ACCEPTED 0
#define MSG_DENIED 1

/* accept_stat */
#define SUCCESS 0
#define PROG_UNAVAIL 1
#define PROG_MISMATCH 2
#define PROC_UNAVAIL 3
#define GARBAGE_ARGS 4

/* reject_stat */
#define RPC_MISMATCH 0
#define AUTH_ERROR 1

/* auth_stat */
#define AUTH_BADCRED 0
#define AUTH_REJECTEDCRED 2
#define AUTH_BADVERF 3
#define AUTH_REJECTEDVERF 4
#define AUTH_TOOWEAK 5

struct rejected_reply {
  enum_t type;
  union {
    struct {
      unsigned int low;
      unsigned int high; } mismatch;
    enum_t error; } u; } ;

struct accepted_reply {
  struct opaque_auth verf;
  enum_t type;
  union {
    struct {
      unsigned int low;
      unsigned int high; } mismatch; } u; } ;

struct reply_body {
  enum_t type;
  union {
    struct accepted_reply accepted;
    struct rejected_reply denied; } u; } ;

struct call_body {
  unsigned int rpcvers;
  unsigned int prog;
  unsigned int vers;
  unsigned int proc;
  struct opaque_auth cred;
  struct opaque_auth verf; } ;

struct rpc_msg {
  unsigned int xid;
  enum_t type;
  union {
    struct call_body call;
    struct reply_body reply; } u; } ;

typedef struct rejected_reply REJECTED_REPLY;
typedef struct accepted_reply ACCEPTED_REPLY;
typedef struct reply_body REPLY_BODY;
typedef struct call_body CALL_BODY;
typedef struct rpc_msg RPC_MSG;

struct auth_unix {
  unsigned int stamp;
  unsigned int mlen;
  char mname[255];
  unsigned int uid;
  unsigned int gid;
  unsigned int gidlen;
  unsigned int gids[10]; } ;

/* wish we could do this, but AUTH_UNIX is #defined as 1... */
/* typedef struct auth_unix AUTH_UNIX; */

unsigned int get_rpcxid();
