#ifndef KERNEL
#include <sys/types.h>
#include <sys/time.h>
#endif

#define NFS_PROGRAM 100003
#define NFS_VERSION 2

#define MOUNT_PROGRAM 100005
#define MOUNT_VERSION 1

#define NFS_RPC_PORT 2049

#define MAXDATA 8192
#define MAXPATHLEN 1024
#define MAXNAMLEN 255
#define COOKIESIZE 4
#define FHSIZE 32

#define NFS_OK 0
#define NFSERR_PERM 1
#define NFSERR_NOENT 2
#define NFSERR_IO 3
#define NFSERR_NXIO 6
#define NFSERR_ACCES 13
#define NFSERR_EXIST 17
#define NFSERR_NODEV 19
#define NFSERR_NOTDIR 20
#define NFSERR_ISDIR 21
#define NFSERR_FBIG 27
#define NFSERR_NOSPC 28
#define NFSERR_ROFS 30
#define NFSERR_NAMETOOLONG 63
#define NFSERR_NOTEMPTY 66
#define NFSERR_DQUOT 69
#define NFSERR_STALE 70
#define NFSERR_WFLUSH 99

#define NFNON 0
#define NFREG 1
#define NFDIR 2
#define NFBLK 3
#define NFCHR 4
#define NFLNK 5

union fhandle {
  char bytes[FHSIZE];
  struct {
    dev_t dev;
    ino_t ino;
    long int usecount; } s; } ;

struct fattr {
  enum_t type;
  unsigned int mode;
  unsigned int nlink;
  unsigned int uid;
  unsigned int gid;
  unsigned int size;
  unsigned int blocksize;
  unsigned int rdev;
  unsigned int blocks;
  unsigned int fsid;
  unsigned int fileid;
  struct timeval atime;
  struct timeval mtime;
  struct timeval ctime; } ;

struct sattr {
  unsigned int mode;
  unsigned int uid;
  unsigned int gid;
  unsigned int size;
  struct timeval atime;
  struct timeval mtime; } ;

struct filename {
  int len;
  char name[MAXNAMLEN+1]; } ;

struct path {
  int len;
  char path[MAXPATHLEN+1]; } ;

struct attrstat {
  enum_t status;
  union {
    struct fattr attributes; } u; } ;

struct diropargs {
  union fhandle dir;
  struct filename name; } ;

struct diropres {
  enum_t status;
  union {
    struct _diropresok {
      union fhandle file;
      struct fattr attributes } ok; } u; } ;

union cookie {
  char bytes[COOKIESIZE];
  unsigned int offset; } ;

struct _readlink_reply {
  enum_t status;
  union {
    struct path path; } u; } ;

struct _read_reply {
  enum_t status;
  union {
    struct _read_reply_ok {
      struct fattr attributes;
      int datalen;
      char data[MAXDATA]; } ok; } u; } ;

struct _statfs_reply {
  enum_t status;
  union {
    struct _statfs_reply_ok {
      unsigned int tsize;
      unsigned int bsize;
      unsigned int blocks;
      unsigned int bfree;
      unsigned int bavail; } ok; } u; } ;

struct _readdir_reply {
  int len;
  char *buf; } ;

struct _readdir_entry {
  unsigned int fileid;
  struct filename name;
  union cookie cookie; } ;

typedef union fhandle FHANDLE;
typedef struct timeval TIMEVAL;
typedef struct fattr FATTR;
typedef struct sattr SATTR;
typedef struct filename FILENAME;
typedef struct path PATH;
typedef struct attrstat ATTRSTAT;
typedef struct diropargs DIROPARGS;
typedef struct diropres DIROPRES;
typedef union cookie COOKIE;

#define MNTPATHLEN 1024
#define MNTNAMLEN 255

struct fhstatus {
  unsigned int status;
  union {
    union fhandle directory; } u; } ;

struct dirpath {
  int len;
  char path[MNTPATHLEN+1]; } ;

struct name {
  int len;
  char name[MNTNAMLEN+1]; } ;

typedef struct fhstatus FHSTATUS;
typedef struct dirpath DIRPATH;
typedef struct name NAME;

bool_t xdr_fhandle();
bool_t xdr_fattr();
bool_t xdr_sattr();
bool_t xdr_filename();
bool_t xdr_path();
bool_t xdr_attrstat();
bool_t xdr_diropargs();
bool_t xdr_diropres();
bool_t xdr_cookie();
bool_t xdr_fhstatus();
bool_t xdr_dirpath();
bool_t xdr_name();

#define MAX_EXPORTS (1<<6)
#define FSID_SHIFT (32-6)
