#ifdef MNFS

#include "param.h"
#include "systm.h"
#include "dir.h"
#include "user.h"
#include "kernel.h"
#include "file.h"
#include "stat.h"
#include "inode.h"
#include "fs.h"
#include "buf.h"
#include "mount.h"
#include "syslog.h"
#ifdef QUOTA
#include "quota.h"
#endif
#include "xdr.h"
#include "rpc.h"
#include "nfs.h"

extern struct dirtemplate mastertemplate;
extern struct inode *ifreeh;
extern struct inode **ifreet;

int hasaccess(ip,au,acc)
struct inode *ip;
struct auth_unix *au;
int acc;
{
 register int m;
 register unsigned int *gp;
 register int i;

 m = acc;
 if (m & IWRITE)
  { if ( ip->i_fs->fs_ronly &&
	 ((ip->i_mode & IFMT) != IFCHR) &&
	 ((ip->i_mode & IFMT) != IFBLK) )
     { u.u_error = EROFS;
       return(0);
     }
    if (ip->i_flag & ITEXT)
     { xrele(ip);
     }
    if (ip->i_flag & ITEXT)
     { u.u_error = ETXTBSY;
       return(0);
     }
  }
 if ((au->uid == 0) || ((uid_t)au->uid == ip->i_uid))
  { return(1);
  }
 if ((uid_t)au->uid != ip->i_uid)
  { m >>= 3;
    if ((gid_t)au->gid != ip->i_gid)
     { gp = &au->gids[au->gidlen];
       for (i=au->gidlen;i>0;i--)
	{ if (ip->i_gid == (gid_t)*--gp)
	   { m <<= 3;
	     break;
	   }
	}
       m >>= 3;
     }
  }
 if ((ip->i_mode&m) == m)
  { return(1);
  }
 u.u_error = EACCES;
 return(0);
}

setattr(ip,sa,au)
struct inode *ip;
SATTR *sa;
struct auth_unix *au;
{
 struct timeval *atv;
 struct timeval *mtv;

 if ( ( (sa->uid != (unsigned int)-1) &&
	((uid_t)sa->uid != ip->i_uid) &&
	au->uid ) ||
      ( (sa->gid != (unsigned int)-1) &&
	((gid_t)sa->gid != ip->i_gid) &&
	au->uid &&
	( ((uid_t)au->uid != ip->i_uid) ||
	  !grpmember(ip->i_gid,au) ) ) ||
      ( (sa->size != (unsigned int)-1) &&
	!hasaccess(ip,au,IWRITE) ) ||
      ( ( (sa->atime.tv_sec != -1L) ||
	  (sa->mtime.tv_sec != -1L) ) &&
	au->uid &&
	((uid_t)au->uid != ip->i_uid) ) )
  { if (u.u_error == 0)
     { u.u_error = EPERM;
     }
    return;
  }
 if (sa->mode != (unsigned int)-1)
  { ip->i_mode &= ~07777;
    if (au->uid)
     { if ((ip->i_mode & IFMT) != IFDIR)
	{ sa->mode &= ~ISVTX;
	}
       if (! grpmember(ip->i_gid,&au))
	{ sa->mode &= ~ISGID;
	}
     }
    ip->i_mode |= 07777 & (int)sa->mode;
    ip->i_flag |= ICHG;
    if ((ip->i_flag&ITEXT) && !(ip->i_mode&ISVTX))
     { xrele(ip);
     }
  }
 if ((sa->uid != (unsigned int)-1) && ((uid_t)sa->uid != ip->i_uid))
  {
#ifdef QUOTA
    long int change;
    change = ip->i_blocks;
    chkdq(ip,-change,1);
    chkiq(ip->i_dev,ip,ip->i_uid,1);
    dqrele(ip->i_dquot);
#endif
    ip->i_uid = sa->uid;
    ip->i_flag |= ICHG;
#ifdef QUOTA
    ip->i_dquot = inoquota(ip);
    chkdq(ip,change,1);
    chkiq(ip->i_dev,(struct inode *)0,ip->i_uid,1);
    if (u.u_error)
     { log(LOG_ERR,"nfs chown: quota u.u_error bug");
     }
#endif
  }
 if ((sa->gid != (unsigned int)-1) && ((gid_t)sa->gid != ip->i_gid))
  { ip->i_gid = sa->gid;
    ip->i_flag |= ICHG;
  }
 if (sa->size != (unsigned int)-1)
  { itrunc(ip,(unsigned long int)sa->size);
  }
 atv = &time;
 mtv = &time;
 if (sa->atime.tv_sec != -1L)
  { atv = &sa->atime;
    ip->i_flag |= IACC|ICHG;
  }
 if (sa->mtime.tv_sec != -1L)
  { mtv = &sa->mtime;
    ip->i_flag |= IUPD|ICHG;
  }
 iupdat(ip,atv,mtv,1);
}

struct inode *lookupin(au,ip,name,nameiop)
struct auth_unix *au;
struct inode *ip;
char *name;
int nameiop;
{
 struct inode *oldcdir;
 struct inode *new;
 uid_t olduid;

 oldcdir = u.u_cdir;
 u.u_cdir = ip;
 u.u_nd.ni_nameiop = nameiop;
 u.u_nd.ni_segflg = UIO_USERSPACE;
 u.u_nd.ni_dirp = name;
 /* namei uses u_uid, eg for sticky directories */
 olduid = u.u_uid;
 u.u_uid = au->uid;
 new = namei(&u.u_nd);
 u.u_uid = olduid;
 u.u_cdir = oldcdir;
 return(new);
}

int grpmember(gid,aup)
register gid_t gid;
register struct auth_unix *aup;
{
 register int i;
 register unsigned int *gidp;

 if (gid == (gid_t)aup->gid)
  { return(1);
  }
 gidp = &aup->gids[aup->gidlen];
 for (i=aup->gidlen;i>0;i--)
  { if (gid == (gid_t)*--gidp)
     { return(1);
     }
  }
 return(0);
}

struct inode *fhtoi(fh)
register FHANDLE *fh;
{
 register struct mount *m;
 register struct fs *fs;
 register struct inode *ip;

 fs = 0;
 for (m=mount;m<mount+NMOUNT;m++)
  { if (m->m_bufp && (m->m_dev == fh->s.dev))
     { fs = m->m_bufp->b_un.b_fs;
       break;
     }
  }
 if (! fs)
  { return(0);
  }
 ip = iget(fh->s.dev,fs,fh->s.ino);
 if (ip == 0)
  { return(0);
  }
 if (ip->i_usecount != fh->s.usecount)
  { /* ought to be able to do what iget does on I/O error? */
    IUNLOCK(ip);
    if (--ip->i_count == 0)
     { if (ifreeh)
	{ *ifreet = ip;
	  ip->i_freeb = ifreet;
	}
       else
	{ ifreeh = ip;
	  ip->i_freeb = &ifreeh;
	}
       ip->i_freef = 0;
       ifreet = &ip->i_freef;
     }
    return(0);
  }
 return(ip);
}

struct inode *nfs_maknode(mode,ndp,au)
int mode;
struct nameidata *ndp;
struct auth_unix *au;
{
 register int i;
 register unsigned int *lp;
 register gid_t *gp;
 struct inode *ip;

 u.u_uid = au->uid;
 u.u_gid = au->gid;
 gp = u.u_groups;
 lp = au->gids;
 for (i=MIN(au->gidlen,NGROUPS-1);i>0;i--)
  { *gp++ = *lp++;
  }
 *gp = NOGROUP;
 ip = maknode(mode,ndp);
 u.u_uid = 0;
 /* No need to restore the group info, since all this runs as root */
 return(ip);
}

int nfssvc_create()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   char *name;
   SATTR *sa;
   struct stat *stb; } *uap = (struct a *) u.u_ap;
 FHANDLE fh;
 struct auth_unix au;
 SATTR sa;
 struct stat stb;
 struct inode *ip;
 struct inode *new;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->sa,(caddr_t)&sa,sizeof(SATTR));
 if (u.u_error)
  { return;
  }
 ip = fhtoi(&fh);
 if (ip == 0)
  { u.u_error = ESTALE;
    return;
  }
 if (! hasaccess(ip,&au,IWRITE))
  { iput(ip);
    return;
  }
 IUNLOCK(ip);
 new = lookupin(&au,ip,uap->name,CREATE);
 if ((new == 0) && (u.u_error == 0))
  { new = nfs_maknode(sa.mode&07777&~ISVTX,&u.u_nd,&au);
  }
 irele(ip);
 if (new && u.u_error) /* how'd this happen? */
  { log(LOG_ERR,"nfssvc_create: new && u.u_error");
    u.u_error = 0;
  }
 if (u.u_error)
  { return;
  }
 setattr(new,&sa,&au);
 if (u.u_error == 0)
  { ino_stat(new,&stb);
  }
 iput(new);
 if (u.u_error == 0)
  { u.u_error = copyout((caddr_t)&stb,(caddr_t)uap->stb,sizeof(struct stat));
  }
}

int nfssvc_link()
{
 struct a {
   FHANDLE *from;
   struct auth_unix *au;
   FHANDLE *to;
   char *tname; } *uap = (struct a *) u.u_ap;
 FHANDLE from;
 FHANDLE to;
 struct auth_unix au;
 struct inode *tdp;
 struct inode *ip;
 struct inode *xp;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->from,(caddr_t)&from,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->to,(caddr_t)&to,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 tdp = fhtoi(&to);
 if (tdp == 0)
  { u.u_error = ESTALE;
    return;
  }
 IUNLOCK(tdp);
 ip = fhtoi(&from);
 if (ip == 0)
  { u.u_error = ESTALE;
    goto done;
  }
 if (((ip->i_mode&IFMT) == IFDIR) && au.uid)
  { iput(ip);
    goto done;
  }
 ip->i_nlink ++;
 ip->i_flag |= ICHG;
 iupdat(ip,&time,&time,1);
 IUNLOCK(ip);
 xp = lookupin(&au,tdp,uap->tname,CREATE);
 if (xp)
  { u.u_error = EEXIST;
    iput(xp);
    goto out;
  }
 if (u.u_error)
  { goto out;
  }
 if (u.u_nd.ni_pdir->i_dev != ip->i_dev)
  { iput(u.u_nd.ni_pdir);
    u.u_error = EXDEV;
    goto out;
  }
 u.u_error = direnter(ip,&u.u_nd);
out:
 if (u.u_error)
  { ip->i_nlink --;
    ip->i_flag |= ICHG;
  }
 irele(ip);
done:
 irele(tdp);
}

int nfssvc_lookup()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   char *name;
   struct stat *stb; } *uap = (struct a *) u.u_ap;
 FHANDLE fh;
 struct auth_unix au;
 struct stat stb;
 struct inode *ip;
 struct inode *new;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 ip = fhtoi(&fh);
 if (ip == 0)
  { u.u_error = ESTALE;
    return;
  }
 if (! hasaccess(ip,&au,IEXEC))
  { iput(ip);
    return;
  }
 IUNLOCK(ip);
 new = lookupin(&au,ip,uap->name,LOOKUP);
 irele(ip);
 if (new)
  { ino_stat(new,&stb);
    iput(new);
  }
 else
  { u.u_error = ENOENT;
  }
 if (u.u_error == 0)
  { u.u_error = copyout((caddr_t)&stb,(caddr_t)uap->stb,sizeof(struct stat));
  }
}

int nfssvc_mkdir()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   char *name;
   SATTR *sa;
   struct stat *stb; } *uap = (struct a *) u.u_ap;
 FHANDLE fh;
 struct auth_unix au;
 SATTR sa;
 struct stat stb;
 struct dirtemplate dirtemplate;
 struct inode *pi;
 struct inode *dp;
 struct inode *ip;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->sa,(caddr_t)&sa,sizeof(SATTR));
 if (u.u_error)
  { return;
  }
 if (sa.size != (unsigned int)-1)
  { u.u_error = EINVAL;
    return;
  }
 pi = fhtoi(&fh);
 if (pi == 0)
  { u.u_error = ESTALE;
    return;
  }
 if (! hasaccess(pi,&au,IWRITE))
  { iput(pi);
    return;
  }
 IUNLOCK(pi);
 ip = lookupin(&au,pi,uap->name,CREATE);
 if (ip)
  { iput(ip);
    u.u_error = EEXIST;
    goto done;
  }
 if (u.u_error)
  { goto done;
  }
 dp = u.u_nd.ni_pdir;
 ip = ialloc(dp,dirpref(dp->i_fs),IFDIR);
 if (ip == 0)
  { iput(dp);
    goto done;
  }
#ifdef QUOTA
 if (ip->i_dquot != NODQUOT)
  { panic("nfssvc_mkdir: dquot");
  }
#endif
 ip->i_flag |= IACC|IUPD|ICHG;
 ip->i_mode = IFDIR;
 ip->i_nlink = 2;
 ip->i_uid = au.uid;
 ip->i_gid = dp->i_gid;
#ifdef QUOTA
 ip->i_dquot = inoquota(ip);
#endif
 iupdat(ip,&time,&time,1);
 setattr(ip,&sa,&au);
 if (u.u_error)
  { goto bad;
  }
 dp->i_nlink ++;
 dp->i_flag |= ICHG;
 iupdat(dp,&time,&time,1);
 dirtemplate = mastertemplate;
 dirtemplate.dot_ino = ip->i_number;
 dirtemplate.dotdot_ino = dp->i_number;
 u.u_error = rdwri( UIO_WRITE,
		    ip,
		    (caddr_t) &dirtemplate,
		    sizeof(dirtemplate),
		    (off_t) 0,
		    UIO_SYSSPACE,
		    (int *) 0 );
 if (u.u_error)
  { dp->i_nlink --;
    dp->i_flag |= ICHG;
    goto bad;
  }
 if (DIRBLKSIZ > ip->i_fs->fs_fsize)
  { panic("nfssvc_mkdir: blksize");
  }
 ip->i_size = DIRBLKSIZ;
 u.u_error = direnter(ip,&u.u_nd);
 dp = 0;
 if (u.u_error)
  { dp = lookupin(&au,pi,uap->name,LOOKUP|NOCACHE);
    if (dp)
     { dp->i_nlink --;
       dp->i_flag |= ICHG;
     }
  }
bad:
 if (u.u_error)
  { ip->i_nlink = 0;
    ip->i_flag |= ICHG;
  }
 if (dp)
  { iput(dp);
  }
 if (u.u_error == 0)
  { ino_stat(ip,&stb);
  }
 iput(ip);
done:
 irele(pi);
 if (u.u_error == 0)
  { u.u_error = copyout((caddr_t)&stb,(caddr_t)uap->stb,sizeof(struct stat));
  }
}

int nfssvc_read()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   unsigned int offset;
   char *buf;
   int count;
   struct stat *stb; } *uap = (struct a *) u.u_ap;
 FHANDLE fh;
 struct auth_unix au;
 struct stat stb;
 struct inode *ip;
 int resid;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 ip = fhtoi(&fh);
 if (ip == 0)
  { u.u_error = ESTALE;
    return;
  }
 if (! (hasaccess(ip,&au,IREAD) || hasaccess(ip,&au,IEXEC)))
  { iput(ip);
    return;
  }
 u.u_error = rdwri(UIO_READ,ip,uap->buf,uap->count,(off_t)uap->offset,UIO_USERSPACE,&resid);
 if (u.u_error)
  { iput(ip);
    return;
  }
 iupdat(ip,&time,&time,1);
 if (uap->stb)
  { ino_stat(ip,&stb);
  }
 iput(ip);
 if (uap->stb)
  { u.u_error = copyout((caddr_t)&stb,(caddr_t)uap->stb,sizeof(struct stat));
  }
 if (u.u_error == 0)
  { u.u_r.r_val1 = uap->count - resid;
  }
}

int nfssvc_readlink()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   char *name;
   int namesize; } *uap = (struct a *) u.u_ap;
 FHANDLE fh;
 struct inode *ip;
 int resid;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 /* ignore au for this one */
 ip = fhtoi(&fh);
 if (ip == 0)
  { u.u_error = ESTALE;
    return;
  }
 resid = uap->namesize;
 if ((ip->i_mode&IFMT) != IFLNK)
  { u.u_error = EINVAL;
    goto out;
  }
 u.u_error = rdwri(UIO_READ,ip,uap->name,uap->namesize,(off_t)0,UIO_USERSPACE,&resid);
out:
 iput(ip);
 u.u_r.r_val1 = uap->namesize - resid;
}

int nfssvc_remove()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   char *name; } *uap = (struct a *) u.u_ap;
 FHANDLE fh;
 struct auth_unix au;
 struct inode *ip;
 struct inode *dp;
 struct inode *new;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 ip = fhtoi(&fh);
 if (ip == 0)
  { u.u_error = ESTALE;
    return;
  }
 if (! hasaccess(ip,&au,IWRITE))
  { iput(ip);
    return;
  }
 IUNLOCK(ip);
 new = lookupin(&au,ip,uap->name,DELETE|LOCKPARENT);
 if (new == 0)
  { goto out;
  }
 dp = u.u_nd.ni_pdir;
 if (((new->i_mode&IFMT) == IFDIR) && au.uid)
  { u.u_error = EPERM;
    goto out1;
  }
 if (new->i_dev != dp->i_dev)
  { u.u_error = EBUSY;
    goto out1;
  }
 if (new->i_flag & ITEXT)
  { xrele(new);
  }
 if (dirremove(&u.u_nd))
  { new->i_nlink --;
    new->i_flag |= ICHG;
  }
out1:
 if (dp == new)
  { irele(new);
  }
 else
  { iput(new);
  }
 iput(dp);
out:
 irele(ip);
}

int nfssvc_rename()
{
 struct a {
   FHANDLE *ffh;
   char *fname;
   struct auth_unix *au;
   FHANDLE *tfh;
   char *tname; } *uap = (struct a *) u.u_ap;
 FHANDLE ffh;
 FHANDLE tfh;
 struct auth_unix au;
 struct inode *fdp;
 struct inode *tdp;
 struct inode *ip;
 struct inode *dp;
 struct inode *xp;
 int doingdirectory;
 ino_t oldparent;
 ino_t newparent;
 int error;
 struct dirtemplate dirbuf;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->ffh,(caddr_t)&ffh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->tfh,(caddr_t)&tfh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 error = 0;
 tdp = fhtoi(&tfh);
 if (tdp == 0)
  { u.u_error = ESTALE;
    return;
  }
 IUNLOCK(tdp);
 fdp = fhtoi(&ffh);
 if (fdp == 0)
  { u.u_error = ESTALE;
    irele(tdp);
    return;
  }
 IUNLOCK(fdp);
 if ( !hasaccess(fdp,&au,IEXEC|IWRITE) ||
      !hasaccess(tdp,&au,IEXEC|IWRITE) )
  { goto done;
  }
 ip = lookupin(&au,fdp,uap->fname,DELETE|LOCKPARENT);
 if (ip == 0)
  { goto done;
  }
 dp = u.u_nd.ni_pdir;
 doingdirectory = 0;
 if ((ip->i_mode&IFMT) == IFDIR)
  { register struct direct *d;
    d = &u.u_nd.ni_dent;
    if ( ((d->d_namlen == 1) && (d->d_name[0] == '.')) ||
	 ((d->d_namlen == 2) && !bcmp(d->d_name,"..",2)) ||
	 (dp == ip) ||
	 (ip->i_flag & IRENAME) )
     { iput(dp);
       if (dp == ip)
	{ irele(ip);
	}
       else
	{ iput(ip);
	}
       irele(fdp);
       irele(tdp);
       u.u_error = EINVAL;
       return;
     }
    ip->i_flag |= IRENAME;
    oldparent = dp->i_number;
    doingdirectory = 1;
  }
 iput(dp);
 ip->i_nlink ++;
 ip->i_flag |= ICHG;
 iupdat(ip,&time,&time,1);
 IUNLOCK(ip);
 xp = lookupin(&au,tdp,uap->tname,CREATE|LOCKPARENT|NOCACHE);
 if (u.u_error)
  { error = u.u_error;
    goto out;
  }
 dp = u.u_nd.ni_pdir;
 if (oldparent != dp->i_number)
  { newparent = dp->i_number;
  }
 else
  { newparent = (ino_t) 0;
  }
 if (doingdirectory && (newparent != (ino_t)0))
  { if (! hasaccess(ip,&au,IWRITE))
     { goto bad;
     }
    do
     { dp = u.u_nd.ni_pdir;
       if (xp)
	{ iput(xp);
	}
       u.u_error = checkpath(ip,dp);
       if (u.u_error)
	{ goto out;
	}
       xp = lookupin(&au,tdp,uap->tname,CREATE|LOCKPARENT|NOCACHE);
       if (u.u_error)
	{ error = u.u_error;
	  goto out;
	}
     } while (dp != u.u_nd.ni_pdir);
  }
 if (xp == 0)
  { if (dp->i_dev != ip->i_dev)
     { error = EXDEV;
       goto bad;
     }
    if (doingdirectory && newparent)
     { dp->i_nlink ++;
       dp->i_flag |= ICHG;
       iupdat(dp,&time,&time,1);
     }
    error = direnter(ip,&u.u_nd);
    if (error)
     { goto out;
     }
  }
 else
  { if ((xp->i_dev != dp->i_dev) || (xp->i_dev != ip->i_dev))
     { error = EXDEV;
       goto bad;
     }
    if (xp->i_number == ip->i_number)
     { goto bad;
     }
    if ( (dp->i_mode & ISVTX) &&
	 au.uid &&
	 ((uid_t)au.uid != dp->i_uid) &&
	 ((uid_t)au.uid != xp->i_uid) )
     { error = EPERM;
       goto bad;
     }
    if ((xp->i_mode&IFMT) == IFDIR)
     { if (!dirempty(xp,dp->i_number) || (xp->i_nlink > 2))
	{ error = ENOTEMPTY;
	  goto bad;
	}
       if (! doingdirectory)
	{ error = ENOTDIR;
	  goto bad;
	}
       cacheinval(dp);
     }
    else if (doingdirectory)
     { error = EISDIR;
       goto bad;
     }
    dirrewrite(dp,ip,&u.u_nd);
    if (u.u_error)
     { error = u.u_error;
       goto bad1;
     }
    xp->i_nlink --;
    if (doingdirectory)
     { if (-- xp->i_nlink != 0)
	{ panic("rename: linked directory");
	}
       itrunc(xp,(u_long)0);
     }
    xp->i_flag |= ICHG;
    iput(xp);
    xp = 0;
  }
 xp = lookupin(&au,fdp,uap->fname,DELETE|LOCKPARENT);
 dp = xp ? u.u_nd.ni_pdir : 0;
 if (xp != ip)
  { if (doingdirectory)
     { panic("rename: lost dir entry");
     }
  }
 else
  { if (doingdirectory && newparent)
     { dp->i_nlink --;
       dp->i_flag |= ICHG;
       error = rdwri( UIO_READ,
		      xp,
		      (caddr_t) &dirbuf,
		      sizeof(struct dirtemplate),
		      (off_t) 0,
		      UIO_SYSSPACE,
		      (int *) 0 );
       if (error == 0)
	{ if ( (dirbuf.dotdot_namlen != 2) ||
	       (dirbuf.dotdot_name[0] != '.') ||
	       (dirbuf.dotdot_name[1] != '.') )
	   { printf("rename: mangled dir\n");
	   }
	  else
	   { dirbuf.dotdot_ino = newparent;
	     rdwri( UIO_WRITE,
		    xp,
		    (caddr_t) &dirbuf,
		    sizeof(struct dirtemplate),
		    (off_t) 0,
		    UIO_SYSSPACE,
		    (int *) 0 );
	     cacheinval(dp);
	   }
	}
     }
    if (dirremove(&u.u_nd))
     { xp->i_nlink --;
       xp->i_flag |= ICHG;
     }
    xp->i_flag &= ~IRENAME;
    if (error == 0)		/* XXX conservative */
     { error = u.u_error;
     }
  }
 if (dp)
  { iput(dp);
  }
 if (xp)
  { iput(xp);
  }
 irele(ip);
 if (error)
  { u.u_error = error;
  }
 goto done;
bad:
 iput(dp);
bad1:
 if (xp)
  { iput(xp);
  }
out:
 ip->i_nlink --;
 ip->i_flag |= ICHG;
 irele(ip);
 if (error)
  { u.u_error = error;
  }
done:
 irele(fdp);
 irele(tdp);
}

int nfssvc_rmdir()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   char *name; } *uap = (struct a *) u.u_ap;
 FHANDLE fh;
 struct auth_unix au;
 struct inode *pi;
 struct inode *ip;
 struct inode *dp;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 pi = fhtoi(&fh);
 if (pi == 0)
  { u.u_error = ESTALE;
    return;
  }
 if (! hasaccess(pi,&au,IEXEC|IWRITE))
  { iput(pi);
    return;
  }
 IUNLOCK(pi);
 ip = lookupin(&au,pi,uap->name,DELETE|LOCKPARENT);
 if (ip == 0)
  { goto done;
  }
 dp = u.u_nd.ni_pdir;
 if (dp == ip)
  { irele(dp);
    iput(ip);
    u.u_error = EINVAL;
    goto done;
  }
 if ((ip->i_mode&IFMT) != IFDIR)
  { u.u_error = ENOTDIR;
    goto out;
  }
 if (ip->i_dev != dp->i_dev)
  { u.u_error = EBUSY;
    goto out;
  }
 if ((ip->i_nlink != 2) || !dirempty(ip,dp->i_number))
  { u.u_error = ENOTEMPTY;
    goto out;
  }
 if (dirremove(&u.u_nd) == 0)
  { goto out;
  }
 dp->i_nlink --;
 dp->i_flag |= ICHG;
 cacheinval(dp);
 iput(dp);
 dp = 0;
 ip->i_nlink -= 2;
 itrunc(ip,(u_long)0);
 cacheinval(ip);
out:
 if (dp)
  { iput(dp);
  }
 iput(ip);
done:
 irele(pi);
}

int nfssvc_setattr()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   SATTR *sa;
   struct stat *stb; } *uap = (struct a *) u.u_ap;
 struct inode *ip;
 FHANDLE fh;
 SATTR sa;
 struct auth_unix au;
 struct stat stb;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->sa,(caddr_t)&sa,sizeof(SATTR));
 if (u.u_error)
  { return;
  }
 ip = fhtoi(&fh);
 if (ip == 0)
  { u.u_error = ESTALE;
    return;
  }
 setattr(ip,&sa,&au);
 if (u.u_error == 0)
  { ino_stat(ip,&stb);
  }
 iput(ip);
 if (u.u_error == 0)
  { u.u_error = copyout((caddr_t)&stb,(caddr_t)uap->stb,sizeof(struct stat));
  }
}

int nfssvc_stat()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   struct stat *stb; } *uap = (struct a *) u.u_ap;
 struct inode *ip;
 FHANDLE fh;
 struct stat stb;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 /* ignore au for this one */
 ip = fhtoi(&fh);
 if (ip == 0)
  { u.u_error = ESTALE;
    return;
  }
 ino_stat(ip,&stb);
 iput(ip);
 u.u_error = copyout((caddr_t)&stb,(caddr_t)uap->stb,sizeof(struct stat));
}

int nfssvc_statfs()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   struct _statfs_reply_ok *fr; } *uap = (struct a *) u.u_ap;
 FHANDLE fh;
 struct _statfs_reply_ok fr;
 struct inode *ip;
 struct fs *fs;
 int avail;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 /* ignore au for this one */
 ip = fhtoi(&fh);
 if (ip == 0)
  { u.u_error = ESTALE;
    return;
  }
 fs = ip->i_fs;
 /* our caller fills in fr.tsize */
 fr.bsize = fs->fs_fsize;
 fr.blocks = fs->fs_dsize;
 fr.bfree = (fs->fs_cstotal.cs_nbfree * fs->fs_frag) + fs->fs_cstotal.cs_nffree;
 avail = fr.bfree - ((fs->fs_dsize * fs->fs_minfree) / 100);
#if 0
 avail = ((fs->fs_dsize * (100-fs->fs_minfree)) / 100) -
					(fs->fs_dsize - fr.bfree);
#endif
 iput(ip);
 fr.bavail = (avail < 0) ? 0 : avail;
 u.u_error = copyout((caddr_t)&fr,(caddr_t)uap->fr,sizeof(fr));
}

int nfssvc_symlink()
{
 struct a {
   FHANDLE *fh;
   char *name;
   struct auth_unix *au;
   char *path; } *uap = (struct a *) u.u_ap;
 FHANDLE fh;
 struct auth_unix au;
 struct inode *ip;
 struct inode *dp;
 char *tp;
 int c;
 int nc;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 tp = uap->path;
 nc = 0;
 while (c=fubyte(tp))
  { if (c < 0)
     { u.u_error = EFAULT;
       return;
     }
    tp ++;
    nc ++;
  }
 dp = fhtoi(&fh);
 if (dp == 0)
  { u.u_error = ESTALE;
    return;
  }
 IUNLOCK(dp);
 ip = lookupin(&au,dp,uap->name,CREATE);
 if (ip)
  { iput(ip);
    u.u_error = EEXIST;
    goto done;
  }
 if (u.u_error)
  { goto done;
  }
 ip = nfs_maknode(IFLNK|0777,&u.u_nd,&au);
 if (ip == 0)
  { goto done;
  }
 u.u_error = rdwri(UIO_WRITE,ip,uap->path,nc,(off_t)0,UIO_USERSPACE,(int *)0);
 iput(ip);
done:
 irele(dp);
}

int nfssvc_write()
{
 struct a {
   FHANDLE *fh;
   struct auth_unix *au;
   unsigned int offset;
   char *buf;
   int count;
   struct stat *stb; } *uap = (struct a *) u.u_ap;
 FHANDLE fh;
 struct auth_unix au;
 struct stat stb;
 struct inode *ip;
 int resid;

 if (! suser())
  { return;
  }
 u.u_error = copyin((caddr_t)uap->fh,(caddr_t)&fh,FHSIZE);
 if (u.u_error)
  { return;
  }
 u.u_error = copyin((caddr_t)uap->au,(caddr_t)&au,sizeof(struct auth_unix));
 if (u.u_error)
  { return;
  }
 ip = fhtoi(&fh);
 if (ip == 0)
  { u.u_error = ESTALE;
    return;
  }
 if (! hasaccess(ip,&au,IWRITE))
  { iput(ip);
    return;
  }
 u.u_error = rdwri(UIO_WRITE,ip,uap->buf,uap->count,(off_t)uap->offset,UIO_USERSPACE,(int *)0);
 if (u.u_error)
  { iput(ip);
    return;
  }
 iupdat(ip,&time,&time,1);
 ino_stat(ip,&stb);
 iput(ip);
 u.u_error = copyout((caddr_t)&stb,(caddr_t)uap->stb,sizeof(struct stat));
}

#endif
