#include <stdio.h>
#include <xdr.h>

#define serr(str) (feof(str) || ferror(str))

static bool_t stdio_getbytes(x,buf,n)
XDR *x;
char *buf;
int n;
{
 FILE *f = (FILE *) x->x_private;

 if (serr(f))
  { return(FALSE);
  }
 if (fread(buf,1,n,f) != n)
  { return(FALSE);
  }
 return(TRUE);
}

static bool_t stdio_putbytes(x,buf,n)
XDR *x;
char *buf;
int n;
{
 FILE *f = (FILE *) x->x_private;

 if (serr(f))
  { return(FALSE);
  }
 if (fwrite(buf,1,n,f) != n)
  { return(FALSE);
  }
 return(TRUE);
}

static u_int stdio_getpostn(x)
XDR *x;
{
 return((u_int)ftell((FILE *)x->x_private));
}

static bool_t stdio_setpostn(x,pos)
XDR *x;
u_int pos;
{
 if (fseek((FILE *)x->x_private,(long)pos,0) == -1)
  { return(FALSE);
  }
 return(TRUE);
}

/* ARGSUSED */
static caddr_t stdio_inline(x,siz)
XDR *x;
u_int siz;
{
 return((caddr_t)0);
}

static VOID stdio_destroy(x)
XDR *x;
{
 fflush((FILE *)x->x_private);
}

static XDR_OPS stdio_ops = { _xdr_generic_getlong,
			     _xdr_generic_putlong,
			     stdio_getbytes,
			     stdio_putbytes,
			     stdio_getpostn,
			     stdio_setpostn,
			     stdio_inline,
			     stdio_destroy };

VOID xdrstdio_create(x,f,op)
XDR *x;
FILE *f;
XDR_OP op;
{
 x->x_op = op;
 x->x_ops = &stdio_ops;
 x->x_private = (caddr_t) f;
}
