#include <xdr.h>

typedef struct {
	  char *iocookie;
	  char *recvbuf;
	  char *sendbuf;
	  int fragislastinrecord;
	  int portioniseor;
	  int recvfill;
	  int recvptr;
	  int recvsize;
	  int sendptr;
	  int sendsize;
	  int toreadinfrag;
	  int (*rproc)();
	  int (*wproc)(); } REC_PVT;

static int recvsome(rp)
REC_PVT *rp;
{
 int n;
 int siz;

 if (rp->toreadinfrag <= 0)
  { unsigned long int hdr;
    if (! retry_op(rp->rproc,rp->iocookie,(char *)&hdr,4))
     { return(0);
     }
    rp->toreadinfrag = hdr & 0x7fffffff;
    rp->fragislastinrecord = hdr >> 31;
  }
 siz = (rp->toreadinfrag > rp->recvsize) ? rp->recvsize : rp->toreadinfrag;
 n = (*rp->rproc)(rp->iocookie,rp->recvbuf,siz);
 if (n <= 0)
  { return(0);
  }
 else
  { rp->recvfill = n;
    rp->recvptr = 0;
    rp->toreadinfrag -= n;
    return(1);
  }
}

static int sendit(rp)
REC_PVT *rp;
{
 if (rp->portioniseor >= 0)
  { if (!sendit1(rp,rp->sendbuf,rp->portioniseor,1))
     { return(FALSE);
     }
    if (rp->sendptr > rp->portioniseor)
     { if (!sendit1( rp,
		     rp->sendbuf + rp->portioniseor,
		     rp->sendptr - rp->portioniseor,
		     0 ))
	{ return(FALSE);
	}
     }
  }
 else
  { if (!sendit1(rp,rp->sendbuf,rp->sendptr,0))
     { return(FALSE);
     }
  }
 rp->sendptr = 0;
 rp->portioniseor = -1;
 return(TRUE);
}

static int sendit1(rp,buf,len,iseor)
REC_PVT *rp;
char *buf;
int len;
int iseor;
{
 unsigned long int prefix;

 prefix = _xdr_reverse_long( (len & 0x7fffffff) |
			     (iseor ? 0x80000000 : 0) );
 if (! retry_op(rp->wproc,rp->iocookie,(char *)&prefix,4))
  { return(0);
  }
 if (! retry_op(rp->wproc,rp->iocookie,buf,len))
  { return(0);
  }
 return(1);
}

static int retry_op(proc,cookie,buf,n)
int (*proc)();
caddr_t cookie;
char *buf;
int n;
{
 int did;

 while (n > 0)
  { did = (*proc)(cookie,buf,n);
    if (did <= 0)
     { return(0);
     }
    buf += did;
    n -= did;
  }
 return(1);
}

static bool_t record_getbytes(x,buf,n)
XDR *x;
char *buf;
u_int n;
{
 REC_PVT *rp = (REC_PVT *) x->x_private;
 int i;
 int left;

 while (left > 0)
  { if (rp->recvptr < rp->recvfill)
     { *buf++ = rp->recvbuf[rp->recvptr++];
       left --;
     }
    else if (! recvsome(rp))
     { return(FALSE);
     }
  }
 return(TRUE);
}

static bool_t record_putbytes(x,buf,n)
XDR *x;
char *buf;
u_int n;
{
 REC_PVT *rp = (REC_PVT *) x->x_private;
 int i;
 int left;

 while (left > 0)
  { if (rp->sendptr < rp->sendsize)
     { rp->sendbuf[rp->sendptr++] = *buf++;
       left --;
     }
    else if (! sendit(rp))
     { return(FALSE);
     }
  }
 return(TRUE);
}

/* ARGSUSED */
static u_int record_getpostn(x)
XDR *x;
{
 return((u_int)-1);
}

/* ARGSUSED */
static bool_t record_setpostn(x,pos)
XDR *x;
u_int pos;
{
 return(FALSE);
}

/* ARGSUSED */
static caddr_t record_inline(x,siz)
XDR *x;
u_int siz;
{
 return((caddr_t)0);
}

static VOID record_destroy(x)
XDR *x;
{
 REC_PVT *rp = (REC_PVT *) x->x_private;

 if (rp->sendptr)
  { sendit(rp);
  }
 free(rp->recvbuf);
 free(rp->sendbuf);
 free((char *)rp);
}

static XDR_OPS record_ops = { _xdr_generic_getlong,
			      _xdr_generic_putlong,
			      record_getbytes,
			      record_putbytes,
			      record_getpostn,
			      record_setpostn,
			      record_inline,
			      record_destroy };

VOID xdrrec_create(x,sendsize,recvsize,iocookie,r,w)
XDR *x;
u_int sendsize;
u_int recvsize;
char *iocookie;
int (*r)();
int (*w)();
{
 char *malloc();
 REC_PVT *rp;

 x->x_ops = &record_ops;
 if (sendsize == 0)
  { sendsize = 1024;
  }
 if (recvsize == 0)
  { recvsize = 1024;
  }
 rp = (REC_PVT *) malloc(sizeof(REC_PVT));
 rp->iocookie = iocookie;
 rp->recvbuf = malloc(recvsize);
 rp->sendbuf = malloc(sendsize);
 rp->fragislastinrecord = 1;
 rp->portioniseor = -1;
 rp->recvfill = 0;
 rp->recvptr = 0;
 rp->recvsize = recvsize;
 rp->sendptr = 0;
 rp->sendsize = sendsize;
 rp->toreadinfrag = 0;
 rp->rproc = r;
 rp->wproc = w;
 x->x_private = (caddr_t) rp;
}

bool_t xdrrec_endofrecord(x,flush)
XDR *x;
bool_t flush;
{
 REC_PVT *rp = (REC_PVT *) x->x_private;

 rp->portioniseor = rp->sendptr;
 return(!flush || sendit(rp));
}

bool_t xdrrec_eof(x)
XDR *x;
{
 REC_PVT *rp = (REC_PVT *) x->x_private;

 return((rp->toreadinfrag > 0) || !rp->fragislastinrecord);
}

bool_t xdrrec_skiprecord(x)
XDR *x;
{
 REC_PVT *rp = (REC_PVT *) x->x_private;

 while (! rp->fragislastinrecord)
  { if (! recvsome(rp))
     { return(FALSE);
     }
  }
 while (rp->toreadinfrag > 0)
  { if (! recvsome(rp))
     { return(FALSE);
     }
  }
 rp->recvptr = rp->recvfill;
 return(TRUE);
}
