#include <xdr.h>

#include "float.h"

int _xdr_float_to_ieee(fp,lp)
float *fp;
u_long *lp;
{
 register struct vax_f_float *in = (struct vax_f_float *) fp;
 register struct ieee_f_float *out = (struct ieee_f_float *) lp;

 if (in->exp == 0)
  { bzero((char *)out,sizeof(struct ieee_f_float));
    return(1);
  }
 if (in->exp <= 2)
  { return(0);
  }
 out->sign = in->sign;
 out->exp = in->exp - 2;
 out->frac_1 = in->frac_1;
 out->frac_2 = in->frac_2;
 return(1);
}

int _xdr_ieee_to_float(fp,lp)
float *fp;
u_long *lp;
{
 register struct ieee_f_float *in = (struct ieee_f_float *) lp;
 register struct vax_f_float *out = (struct vax_f_float *) fp;

 if (*lp == 0)
  { bzero((char *)out,sizeof(struct vax_f_float));
    return(1);
  }
 if (in->exp >= 0xfe)
  { return(0);
  }
 out->sign = in->sign;
 out->exp = in->exp + 2;
 out->frac_1 = in->frac_1;
 out->frac_2 = in->frac_2;
 return(1);
}

int _xdr_double_to_ieee(dp,lp)
double *dp;
u_long *lp;
{
 register struct vax_d_float *in = (struct vax_d_float *) dp;
 register struct ieee_d_float *out = (struct ieee_d_float *) lp;
 register u_int ui;

 if (in->exp == 0)
  { bzero((char *)out,sizeof(struct ieee_d_float));
    return(1);
  }
 out->sign = in->sign;
 ui = in->exp;
 ui += 1023 - 129;
 out->exp = ui;
 out->frac_1 = (in->frac_1 >> 3);
 out->frac_2 = (in->frac_2 >> 3) | ((u_int)in->frac_1 << 13);
 out->frac_3 = (in->frac_3 >> 3) | (in->frac_2 << 13);
 out->frac_4 = (in->frac_4 >> 3) | (in->frac_3 << 13);
 return(1);
}

int _xdr_ieee_to_double(fp,lp)
double *fp;
u_long *lp;
{
 register struct ieee_d_float *in = (struct ieee_d_float *) lp;
 register struct vax_d_float *out = (struct vax_d_float *) fp;
 register u_int ui;

 if ((lp[0] == 0) && (lp[1] == 0))
  { bzero((char *)out,sizeof(struct vax_d_float));
    return(1);
  }
 ui = in->exp;
 ui += 129 - 1023;
 out->exp = ui;
 ui >>= 8;
 if (ui && ~ui)
  { return(0);
  }
 out->sign = in->sign;
 out->frac_1 = (in->frac_1 << 3) | (in->frac_2 >> 13);
 out->frac_2 = (in->frac_2 << 3) | (in->frac_3 >> 13);
 out->frac_3 = (in->frac_3 << 3) | (in->frac_4 >> 13);
 out->frac_4 = (in->frac_4 << 3);
 return(1);
}
