#include <xdr.h>

char nullbytes[] = { 0, 0, 0 };
char junkbytes[3];

bool_t xdr_string(x,sp,maxlen)
XDR *x;
char **sp;
u_int maxlen;
{
 u_int l;

 switch (x->x_op)
  { case XDR_ENCODE:
       l = (u_int) strlen(*sp);
       return( (l <= maxlen) &&
	       xdr_u_long(x,&l) &&
	       (*x->x_ops->x_putbytes)(x,*sp,l) &&
	       ( ((l%4) == 0) ||
		 (*x->x_ops->x_putbytes)(x,nullbytes,4-(l%4)) ) );
       break;
    case XDR_DECODE:
       if (! xdr_u_long(x,&l))
	{ return(FALSE);
	}
       if (l > maxlen)
	{ return(FALSE);
	}
       if (!*sp)
	{ char *malloc();
	  *sp = malloc(l+1);
	}
       if (! (*x->x_ops->x_getbytes)(x,*sp,l))
	{ return(FALSE);
	}
       (*sp)[l] = '\0';
       return( ((l%4) == 0) ||
	       (*x->x_ops->x_getbytes)(x,junkbytes,4-(l%4)) );
       break;
    case XDR_FREE:
       if (*sp)
	{ free(*sp);
	  *sp = 0;
	}
       return(TRUE);
       break;
  }
}

bool_t xdr_bytes(x,bpp,lp,maxlen)
XDR *x;
char **bpp;
u_int *lp;
u_int maxlen;
{
 switch (x->x_op)
  { case XDR_ENCODE:
       return( (*lp <= maxlen) &&
	       xdr_u_long(x,lp) &&
	       (*x->x_ops->x_putbytes)(x,*bpp,*lp) &&
	       ( (((*lp)%4) == 0) ||
		 (*x->x_ops->x_putbytes)(x,nullbytes,4-((*lp)%4)) ) );
       break;
    case XDR_DECODE:
       if (! xdr_u_long(x,lp))
	{ return(FALSE);
	}
       if (*lp > maxlen)
	{ return(FALSE);
	}
       if (!*bpp)
	{ char *malloc();
	  *bpp = malloc(maxlen);
	}
       if (! (*x->x_ops->x_getbytes)(x,*bpp,*lp))
	{ return(FALSE);
	}
       return( (((*lp)%4) == 0) ||
	       (*x->x_ops->x_getbytes)(x,junkbytes,4-((*lp)%4)) );
       break;
    case XDR_FREE:
       if (*bpp)
	{ free(*bpp);
	  *bpp = 0;
	}
       return(TRUE);
       break;
  }
}

bool_t xdr_array(x,ap,lp,maxlen,elsize,xdr_el)
XDR *x;
char **ap;
u_int *lp;
u_int maxlen;
u_int elsize;
bool_t (*xdr_el)();
{
 int i;

 switch (x->x_op)
  { case XDR_ENCODE:
       if ( (*lp > maxlen) ||
	    ! xdr_u_long(x,lp) )
	{ return(FALSE);
	}
       for (i=0;i<*lp;i++)
	{ if (! (*xdr_el)(x,(*ap)+(elsize*i)))
	   { return(FALSE);
	   }
	}
       return(TRUE);
       break;
    case XDR_DECODE:
       if (! xdr_u_long(x,lp))
	{ return(FALSE);
	}
       if (*lp > maxlen)
	{ return(FALSE);
	}
       if (!*ap)
	{ char *malloc();
	  *ap = malloc(elsize*maxlen);
	}
       for (i=0;i<*lp;i++)
	{ if (! (*xdr_el)(x,(*ap)+(elsize*i)))
	   { return(FALSE);
	   }
	}
       return(TRUE);
       break;
    case XDR_FREE:
       if (*ap)
	{ for (i=0;i<*lp;i++)
	   { if (! (*xdr_el)(x,(*ap)+(elsize*i)))
	      { return(FALSE);
	      }
	   }
	  free(*ap);
	  *ap = 0;
	}
       return(TRUE);
       break;
  }
}

bool_t xdr_opaque(x,p,len)
XDR *x;
char *p;
u_int len;
{
 switch (x->x_op)
  { case XDR_ENCODE:
       return( (*x->x_ops->x_putbytes)(x,p,len) &&
	       ( ((len%4) == 0) ||
		 (*x->x_ops->x_putbytes)(x,nullbytes,4-(len%4)) ) );
       break;
    case XDR_DECODE:
       return( (*x->x_ops->x_getbytes)(x,p,len) &&
	       ( ((len%4) == 0) ||
		 (*x->x_ops->x_getbytes)(x,junkbytes,4-(len%4)) ) );
       break;
  }
}

bool_t xdr_union(x,selector,unp,arms,defaultarm)
XDR *x;
enum_t *selector;
char *unp;
XDR_DISCRIM *arms;
bool_t (*defaultarm)();
{
 int i;

 if (! xdr_enum(x,selector))
  { return(FALSE);
  }
 for (i=0;arms[i].proc;i++)
  { if (arms[i].value == *selector)
     { return((*arms[i].proc)(x,unp));
     }
  }
 return( defaultarm &&
	 (*defaultarm)(x,unp) );
}

bool_t xdr_reference(x,pp,size,proc)
XDR *x;
char **pp;
u_int size;
bool_t (*proc)();
{
 switch (x->x_op)
  { case XDR_ENCODE:
       return((*proc)(x,*pp));
       break;
    case XDR_DECODE:
       if (!*pp)
	{ char *malloc();
	  *pp = malloc(size);
	}
       return((*proc)(x,*pp));
       break;
    case XDR_FREE:
       if (*pp)
	{ free(*pp);
	  *pp = 0;
	}
  }
}

bool_t xdr_wrapstring(x,sp)
XDR *x;
char **sp;
{
 return(xdr_string(x,sp,(u_int)-1));
}
