#ifndef _HTABLE_H_
#define _HTABLE_H_

char *add_hentry();
char *del_hentry();
char *del_one_hentry();
char *find_hentry();
int htable_entries();
char *new_htable();
int string_cmpfxn();
int string_hfxn();
/*
	char *add_hentry(Tbl,entry)
		add an entry, returning already-there?old-entry:0
	add_new_hentry(Tbl,entry)
		add an entry, assuming it's not already there
	clear_htable(Tbl)
		throws away all entries
	char *del_hentry(Tbl,entry)
		delete the entry, returning it (0 if not there)
	char *del_one_hentry(Tbl)
		delete any one entry, returning it (0 if no more)
	char *find_hentry(Tbl,entry)
		find the entry, if it exists (0 otherwise)
	free_htable(Tbl)
		throws away the table
	hset_cmpfxn(Tbl,cmpfxn)
		change the comparison function (does not rehash)
	int htable_entries(Tbl)
		return the number of entries
	map_htable(Tbl,fxn)
		call (*fxn)(entry) for each entry in htable
	char *new_htable(hfxn,cmpfxn)
		create and return a new htable

	int string_cmpfxn(s1,s2)
		comparison function suited to hashing on strings
	int string_hfxn(str,siz)
		hash function suited to hashing on strings

calling sequence for hfxns and cmpfxns:
	hfxn(object,tablesize) -- returns [0..tablesize)
	cmpfxn(object,entry) -- 0 for match, nonzero otherwise
*/

#endif _HTABLE_H_
