#ifndef _XDR_
#define _XDR_

#ifndef KERNEL
#include <sys/types.h>
#endif
typedef int bool_t;
#define FALSE 0
#define TRUE 1

#define VOID void
typedef int enum_t;

enum xdr_op {
  XDR_ENCODE = 0,
  XDR_DECODE = 1,
  XDR_FREE = 2 };

struct xdr_ops {
  bool_t (*x_getlong)();
  bool_t (*x_putlong)();
  bool_t (*x_getbytes)();
  bool_t (*x_putbytes)();
  u_int (*x_getpostn)();
  bool_t (*x_setpostn)();
  caddr_t (*x_inline)();
  VOID (*x_destroy)(); };

typedef struct {
	  enum xdr_op x_op;
	  struct xdr_ops *x_ops;
	  caddr_t x_public;
	  caddr_t x_private;
	  caddr_t x_base;
	  int x_handy; } XDR;

struct xdr_discrim {
  enum_t value;
  bool_t (*proc)(); };

int _xdr_double_to_ieee();
int _xdr_float_to_ieee();
bool_t _xdr_generic_getlong();
bool_t _xdr_generic_putlong();
int _xdr_ieee_to_double();
int _xdr_ieee_to_float();
long int _xdr_reverse_long();

#define __dontcare__ ((enum_t)0)

long *xdr_inline();
bool_t xdr_array();
bool_t xdr_bool();
bool_t xdr_bytes();
VOID xdr_destroy();
bool_t xdr_double();
bool_t xdr_enum();
bool_t xdr_float();
u_int xdr_getpos();
bool_t xdr_int();
bool_t xdr_long();
bool_t xdr_opaque();
bool_t xdr_reference();
bool_t xdr_setpos();
bool_t xdr_short();
bool_t xdr_string();
bool_t xdr_u_int();
bool_t xdr_u_long();
bool_t xdr_u_short();
bool_t xdr_union();
bool_t xdr_void();
bool_t xdr_wrapstring();
VOID xdrmem_create();
VOID xdrrec_create();
bool_t xdrrec_endofrecord();
bool_t xdrrec_eof();
bool_t xdrrec_skiprecord();
VOID xdrstdio_create();

typedef enum xdr_op XDR_OP;
typedef struct xdr_ops XDR_OPS;
typedef struct xdr_discrim XDR_DISCRIM;

#endif
