#include <xdr.h>

bool_t xdr_int(x,ip)
XDR *x;
int *ip;
{
 return(xdr_long(x,(long int *)ip));
}

bool_t xdr_u_int(x,up)
XDR *x;
u_int *up;
{
 return(xdr_long(x,(long int *)up));
}

bool_t xdr_long(x,lp)
XDR *x;
long *lp;
{
 switch (x->x_op)
  { case XDR_ENCODE:
       return((*x->x_ops->x_putlong)(x,lp));
       break;
    case XDR_DECODE:
       return((*x->x_ops->x_getlong)(x,lp));
       break;
  }
 return(TRUE);
}

bool_t xdr_u_long(x,lup)
XDR *x;
u_long *lup;
{
 return(xdr_long(x,(long *)lup));
}

bool_t xdr_short(x,sp)
XDR *x;
short *sp;
{
 long l;

 switch (x->x_op)
  { case XDR_ENCODE:
       l = (long) *sp;
       return(xdr_long(x,&l));
       break;
    case XDR_DECODE:
       if (! xdr_long(x,&l))
	{ return(FALSE);
	}
       *sp = (short) l;
       return(TRUE);
       break;
  }
}

bool_t xdr_u_short(x,sup)
XDR *x;
u_short *sup;
{
 u_long l;

 switch (x->x_op)
  { case XDR_ENCODE:
       l = (u_long) *sup;
       return(xdr_u_long(x,&l));
       break;
    case XDR_DECODE:
       if (! xdr_u_long(x,&l))
	{ return(FALSE);
	}
       *sup = (u_short) l;
       break;
  }
}

bool_t xdr_float(x,fp)
XDR *x;
float *fp;
{
 u_long l;

 switch (x->x_op)
  { case XDR_ENCODE:
       if (! _xdr_float_to_ieee(fp,&l))
	{ return(FALSE);
	}
       return(xdr_u_long(x,&l));
       break;
    case XDR_DECODE:
       if (! xdr_u_long(x,&l))
	{ return(FALSE);
	}
       return(_xdr_ieee_to_float(fp,&l));
       break;
  }
 return(TRUE);
}

bool_t xdr_double(x,dp)
XDR *x;
double *dp;
{
 u_long l[2];

 switch (x->x_op)
  { case XDR_ENCODE:
       if (! _xdr_double_to_ieee(dp,l))
	{ return(FALSE);
	}
       return(xdr_u_long(x,&l[1]) && xdr_u_long(x,&l[0]));
       break;
    case XDR_DECODE:
       if (! (xdr_u_long(x,&l[1]) && xdr_u_long(x,&l[0])))
	{ return(FALSE);
	}
       return(_xdr_ieee_to_double(dp,l));
       break;
  }
 return(TRUE);
}

bool_t xdr_enum(x,ep)
XDR *x;
enum_t *ep;
{
 return(xdr_int(x,(int *)ep));
}

bool_t xdr_bool(x,bp)
XDR *x;
bool_t *bp;
{
 return(xdr_int(x,(int *)bp));
}

bool_t xdr_void()
{
 return(TRUE);
}
