#include <xdr.h>

static bool_t memory_getbytes(x,buf,n)
XDR *x;
char *buf;
u_int n;
{
 if (x->x_private+n > x->x_base+x->x_handy)
  { return(FALSE);
  }
 bcopy(x->x_private,buf,n);
 x->x_private += n;
 return(TRUE);
}

static bool_t memory_putbytes(x,buf,n)
XDR *x;
char *buf;
u_int n;
{
 if (x->x_private+n > x->x_base+x->x_handy)
  { return(FALSE);
  }
 bcopy(buf,x->x_private,n);
 x->x_private += n;
 return(TRUE);
}

static u_int memory_getpostn(x)
XDR *x;
{
 return(x->x_private-x->x_base);
}

static bool_t memory_setpostn(x,pos)
XDR *x;
u_int pos;
{
 if (pos > x->x_handy)
  { return(FALSE);
  }
 x->x_private = x->x_base + pos;
 return(TRUE);
}

static caddr_t memory_inline(x,siz)
XDR *x;
u_int siz;
{
 caddr_t rv;

 if (x->x_private+siz > x->x_base+x->x_handy)
  { return((caddr_t)0);
  }
 rv = x->x_private;
 x->x_private += siz;
 return(rv);
}

/* ARGSUSED */
static VOID memory_destroy(x)
XDR *x;
{
}

static XDR_OPS memory_ops = { _xdr_generic_getlong,
			      _xdr_generic_putlong,
			      memory_getbytes,
			      memory_putbytes,
			      memory_getpostn,
			      memory_setpostn,
			      memory_inline,
			      memory_destroy };

VOID xdrmem_create(x,buf,size,op)
XDR *x;
char *buf;
u_int size;
XDR_OP op;
{
 x->x_op = op;
 x->x_ops = &memory_ops;
 x->x_base = buf;
 x->x_private = buf;
 x->x_handy = (int) size;
}
