#include <xdr.h>
#include <sys/stat.h>
#include <sys/time.h>

bool_t xdr_struct_stat(x,stb)
XDR *x;
struct stat *stb;
{
#define RETIF(e) if (! e) return(FALSE)
 RETIF(xdr_dev_t(x,&stb->st_dev));
 RETIF(xdr_ino_t(x,&stb->st_ino));
 RETIF(xdr_u_short(x,&stb->st_mode));
 RETIF(xdr_short(x,&stb->st_nlink));
 RETIF(xdr_short(x,&stb->st_uid));
 RETIF(xdr_short(x,&stb->st_gid));
 RETIF(xdr_dev_t(x,&stb->st_rdev));
 RETIF(xdr_off_t(x,&stb->st_size));
 RETIF(xdr_time_t(x,&stb->st_atime));
 RETIF(xdr_time_t(x,&stb->st_mtime));
 RETIF(xdr_time_t(x,&stb->st_ctime));
 RETIF(xdr_long(x,&stb->st_blksize));
 RETIF(xdr_long(x,&stb->st_blocks));
 return(TRUE);
}

bool_t xdr_dev_t(x,dev)
XDR *x;
dev_t *dev;
{
 return(xdr_short(x,(short *)dev));
}

bool_t xdr_ino_t(x,ino)
XDR *x;
ino_t *ino;
{
 return(xdr_u_long(x,(u_long *)ino));
}

bool_t xdr_off_t(x,off)
XDR *x;
off_t *off;
{
 return(xdr_int(x,(int *)off));
}

bool_t xdr_time_t(x,time)
XDR *x;
time_t *time;
{
 return(xdr_int(x,(int *)time));
}

bool_t xdr_struct_timeval(x,tvp)
XDR *x;
struct timeval *tvp;
{
 return(xdr_long(x,&tvp->tv_sec) && xdr_long(x,&tvp->tv_usec));
}
