#include <xdr.h>
#include <rpc.h>

#define RETIF(foo) if (! (foo)) return(FALSE)

bool_t xdr_opaque_auth(x,oa)
XDR *x;
OPAQUE_AUTH *oa;
{
 char *bp;

 if (x->x_op == XDR_FREE)
  { return(TRUE);
  }
 bp = &oa->body[0];
 return( xdr_enum(x,&oa->type) &&
	 xdr_bytes(x,&bp,&oa->len,400) );
}

static bool_t xdr_lowhigh(x,lh)
XDR *x;
struct {
  unsigned int low;
  unsigned int high; } *lh;
{
 return(xdr_u_int(x,&lh->low) && xdr_u_int(x,&lh->high));
}

bool_t xdr_rejected_reply(x,rrp)
XDR *x;
REJECTED_REPLY *rrp;
{
 static XDR_DISCRIM rrxd[] = { { RPC_MISMATCH, xdr_enum },
			       { AUTH_ERROR, xdr_lowhigh },
			       { __dontcare__, 0 } };

 return(xdr_union(x,&rrp->type,(char *)&rrp->u,rrxd,(bool_t (*)())0));
}

bool_t xdr_accepted_reply(x,arp)
XDR *x;
ACCEPTED_REPLY *arp;
{
 static XDR_DISCRIM arxd[] = { { SUCCESS, xdr_void },
			       { PROG_MISMATCH, xdr_lowhigh },
			       { __dontcare__, 0 } };

 return( xdr_opaque_auth(x,&arp->verf) &&
	 xdr_union(x,&arp->type,(char *)&arp->u,arxd,xdr_void) );
}

bool_t xdr_reply_body(x,rbp)
XDR *x;
REPLY_BODY *rbp;
{
 static XDR_DISCRIM rbxd[] = { { MSG_ACCEPTED, xdr_accepted_reply },
			       { MSG_DENIED, xdr_rejected_reply },
			       { __dontcare__, 0 } };

 return(xdr_union(x,&rbp->type,(char *)&rbp->u,rbxd,(bool_t (*)())0));
}

bool_t xdr_call_body(x,cbp)
XDR *x;
CALL_BODY *cbp;
{
 return( xdr_u_int(x,&cbp->rpcvers) &&
	 xdr_u_int(x,&cbp->prog) &&
	 xdr_u_int(x,&cbp->vers) &&
	 xdr_u_int(x,&cbp->proc) &&
	 xdr_opaque_auth(x,&cbp->cred) &&
	 xdr_opaque_auth(x,&cbp->verf) );
}

bool_t xdr_rpc_msg(x,rmp)
XDR *x;
RPC_MSG *rmp;
{
 static XDR_DISCRIM rmxd[] = { { CALL, xdr_call_body },
			       { REPLY, xdr_reply_body },
			       { __dontcare__, 0 } };

 return( xdr_u_int(x,&rmp->xid) &&
	 xdr_union(x,&rmp->type,(char *)&rmp->u,rmxd,(bool_t (*)())0) );
}

bool_t xdr_auth_unix(x,au)
XDR *x;
struct auth_unix *au;
{
 char *mp;
 unsigned int *gp;

 if (x->x_op == XDR_FREE)
  { return(TRUE);
  }
 mp = &au->mname[0];
 gp = &au->gids[0];
 return( xdr_u_int(x,&au->stamp) &&
	 xdr_bytes(x,&mp,&au->mlen,255) &&
	 xdr_u_int(x,&au->uid) &&
	 xdr_u_int(x,&au->gid) &&
	 xdr_array(x,(char **)&gp,&au->gidlen,10,
				sizeof(unsigned int),xdr_u_int) );
}
