#ifndef lint
  static char *RCSid = "$Header: driver.c,v 1.5.1 88/02/26 jerry Rel $";
#endif

/* driver --
   drive the IEN 116 nameserver.

   Modified by Jerry Aguirre.  21Mar1988
   First argument is name of server to use.  Other arguments are names
   to find.  More extensive display of responses.

   Written by Michael I. Bushnell.
   Copyright (c) 1987 Michael I. Bushnell
   You are hereby granted permission to use this program however you wish, 
   including copying and distribution.  However, you are obligated not to sell
   it or any part of it.  Anyone who obtains this program receives the right
   to do the same.  This statement may not be removed from this program.
*/

/*
 * $Source: /u1/staff/mike/src/nameserver/RCS/driver.c,v $
 * $Revision: 1.5 $
 * $Date: 87/06/24 15:02:38 $
 * $State: Rel $
 * $Author: mike $
 * $Locker:  $
 * $Log:	driver.c,v $
 * Revision 1.5.1 88/02/26 Jerry Aguirre <jerry@olivetti.com>
 * Field sizes don't include 2 byte header.  First arg is now name
 * of server to request from.  Structure of response message is displayed.
 *
 * Revision 1.5  87/06/24  15:02:38  mike
 * Prepared for final release.  Added Copyright.
 * 
 * Revision 1.4  87/06/19  17:00:05  mike
 * More toying around.
 * 
 * Revision 1.3  87/06/19  14:44:13  mike
 * Toyed around.
 * 
 * Revision 1.2  87/06/15  13:50:51  mike
 * Changed the host it asks for
 * 
 * Revision 1.1  87/06/12  13:42:29  mike
 * Initial revision
 * 
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <netdb.h>

#include "ien116.h"

#define BUFLEN 2000
char buf[BUFLEN];

/* Driver for the IEN 116 nameserver */

main(argc, argv) int argc; char *argv[];
{
  int sock;			/* Datagram socket */
  struct sockaddr_in from;	/* Where we got the reply from */
  struct sockaddr_in server;	/* Server's address */
  struct sockaddr_in ourname;	/* Our address */
  int addrlen;			/* Address length */
  int c,i;			/* Generic counters */
  int arg;
  struct hostent *hp, *gethostbyname();	/* Host inquired of */
  char *hostname;
  int j, k;
  int code, length;
  
  if (argc < 3) {
    printf("usage: driver server name ...");
    exit(1);
  }

  sock = socket(AF_INET, SOCK_DGRAM, 0);
  if (sock < 0)
    {
      perror("driver: opening socket");
      exit (1);
    }
  ourname.sin_family = AF_INET;
  ourname.sin_port = 0;
  ourname.sin_addr.s_addr = INADDR_ANY;
  if (bind(sock, (struct sockaddr *)&ourname, sizeof(ourname)))
    {
      perror("driver: binding socket");
      exit(1);
    }
  
  /* server.sin_family = AF_INET; */
  server.sin_port = htons((u_short)PORT);
  /* server.sin_addr.s_addr = INADDR_ANY; */
  server.sin_addr.s_addr = INADDR_ANY;
  hp = gethostbyname(argv[1]);
  if (hp) {
	  server.sin_family = hp->h_addrtype;
#ifndef	NOT43
	  bcopy(hp->h_addr_list[0], (caddr_t)&server.sin_addr,
		  hp->h_length);
#else	NOT43
	  bcopy(hp->h_addr, (caddr_t)&server.sin_addr,
		  hp->h_length);
#endif	NOT43
	  hostname = hp->h_name;
  } else {
	  printf("%s: unknown host\n", argv[1]);
	  exit(1);
  }

  for (arg = 2; arg < argc; arg++) {
    i = strlen(argv[arg]);
    buf[0] = ADDR_REQ;		/* Code for request */
    buf[1] = i;			/* Length of message */
    strcpy(buf+2, argv[arg]);	/* name */

    if (sendto(sock, buf, i+2, 0, (struct sockaddr *)&server, sizeof(server))==-1)
      {
	perror("driver: sending message");
	exit(1);
      }

    if ((c=recvfrom(sock, buf, BUFLEN, 0, (struct sockaddr *)&from, sizeof(from)))==-1)
      {
	perror("driver: getting message");
	exit(1);
      }

    printf("response for \"%s\" (%d bytes):\n", argv[arg], c);
    for(i=0;(i + 1) <c;) {
      putchar('\t');
      code = buf[i++] & 0xff;
      length = buf[i++] & 0xff;
      switch (code) {
      case ADDR_REQ:
        printf("ADDR_REQ: length %d \"", length);
	for (k = 0; k < length; k++) {
	  if ((buf[i+k] >= ' ') && (buf[i+k] <= '~')) putchar(buf[i+k]);
	  else printf("\\%3.3o", buf[i+k] & 0xff);
	}
	printf("\"");
	break;
      case ADDR_ANS:
        printf("ADDR_ANS: length %d", length);
	for (k = 0; k < length; k++) {
	  if (k == 0) printf(" %d", buf[i+k] & 0xff);
	  else        printf(".%d", buf[i+k] & 0xff);
	}
	break;
      case ERR:
        printf("ERR: length %d", length);
	for (k = 0; k < length; k++) {
	  j = buf[i+k] & 0xff;
	  printf(" error code %d", j);
	  switch (j) {
	      case UNK_ERR:
		printf(" UNK_ERR");
	      break;
	      case HOST_UNK:
		printf(" HOST_UNK");
	      break;
	      case SYNT_ERR:
		printf(" SYNT_ERR");
	      break;
	      default:
		printf("????");
	  }
	}
	break;
      default:
        printf("Unknown response code 0x%x, length %d.", buf[i] & 0xff, length);
	break;
      }
      i += length;
      printf("\n");
    }
  }	/* for each arg */
}
