/* $Id: ethertest.c,v 1.3 89/10/24 17:54:39 dupuy Exp $ */

#include <stdio.h>
#include <strings.h>			/* strcmp */

#include <sys/param.h>			/* MAXHOSTNAMELEN */
#include <sys/uio.h>			/* iov */
#include <sys/socket.h>

#include <errno.h>			/* EAGAIN */
#include <netdb.h>			/* hostent */

#include <netinet/in.h>			/* in_addr */

#include "ether.h"

#if defined(lint) && defined (ultrix)
void bcopy ();
void perror ();
void exit ();
unsigned sleep ();
#endif

#if !defined (sun) && !defined (ultrix)
extern uid_t getuid ();
#endif

#define offsetof(type,mem) ((unsigned) &(((type *) 0)->mem))

char hello[] = "hello,";
char world[] = " world";
struct iovec iov[2] = {{hello, 6}, {world, 7}};
char helloworld[] = "hello, world";
struct iovec iov2[1] = {{helloworld, 13}};

#ifdef __STDC__
ether_addr multicast = {{ 0x0f, 0x0f, 0x0f, 0xfe, 0xfe, 0x00 }};
#else
ether_addr multicast;
unsigned char bytes[6] = { 0x0f, 0x0f, 0x0f, 0xfe, 0xfe, 0x00 };
#endif
char mcastname1[] = "0f:0F:f:Fe:fE:0";
char mcastname2[] = "0f-0F-f-Fe-fE-0";

ether_vec packetv;
ether_packet packet;

char *inet_n2a ();

extern int errno;

main ()
{
    char hostname[MAXHOSTNAMELEN + 1];
    char *hname = NULL;
    struct hostent *hdata;
    ether_addr eaddress;
    ether_addr eaddress2;
    ether_addr eaddress3;
    char **intfs;
    int uid;
    int i = ETHER_SRC;

    /*
     * Initialize union
     */

#ifndef __STDC__
    (void) bcopy ((char *) bytes, (char *) multicast.bytes, sizeof (bytes));
#endif

    /*
     * Test some structures for compiler sanity
     */

    if (i != sizeof (ether_addr))
	(void) fprintf (stderr, "WARNING!!! sizeof (ether_addr) = %d\n",
			sizeof (ether_addr));
    if (ETHER_PKT != offsetof (ether_packet, type[2]))
	(void) fprintf (stderr, "WARNING!!! offset of ether_packet = %d\n",
			offsetof (ether_packet, type[2]));

#ifdef __GNUC__
    (void) printf ("ether_addr alignment = %d, ether_packet alignment = %d\n",
		   __alignof (ether_addr), __alignof (ether_packet));
#endif

    /*
     * Get the canonical hostname
     */

    if (gethostname (hostname, sizeof (hostname)) < 0)
	perror ("gethostname");
    else
    {
	hname = hostname;

	if ((hdata = gethostbyname (hostname)) == 0)
	    (void) fprintf (stderr, "host info for %s not found\n", hostname);
	else
	{
	    hname = hdata->h_name;

	    if ((hdata = gethostbyaddr (hdata->h_addr, hdata->h_length,
					hdata->h_addrtype)) == 0)
		(void) fprintf (stderr, "%s address does not match\n", hname);
	    else
		hname = hdata->h_name;

	}
    }

    if (hname)
	(void) printf ("%s ethertest\n", hname);

    /*
     * Get the ethernet interface names and test some utility functions
     */

    if ((intfs = ether_interfaces ()) == NULL)
    {
	perror ("ether_interfaces");
	exit (1);
    }

    if (hname)
    {
	if (ether_host2e (hostname, &eaddress) == NULL)
	    (void) fprintf (stderr, "ether_h2e failed\n");
	else
	    (void) printf ("%s: %s\n", hostname, ether_ntoa (&eaddress));
    }

    if (hdata)
    {
	struct in_addr ipaddr;

	(void) bcopy (hdata->h_addr, (char *) &ipaddr, sizeof (ipaddr));
	if (ether_hostent2e (hdata, &eaddress2) == NULL)
	    (void) fprintf (stderr, "ether_he2e failed\n");

	else if (bcmp ((char *) &eaddress, (char *) &eaddress2,
		       sizeof (ether_addr)))
	    (void) printf ("%s: %s\n", hdata->h_name, ether_ntoa (&eaddress2));

	if (ether_ip2e (&ipaddr, &eaddress3) == NULL)
	    perror ("ether_ip2e");

	else if (bcmp ((char *) &eaddress3, (char *) &eaddress2,
		       sizeof (ether_addr)))
	    (void) printf ("%s: %s\n", inet_n2a (ipaddr),
			   ether_ntoa (&eaddress3));
    }

    uid = getuid ();

    /*
     * Loop through the interfaces, testing functions
     */

    for (i = 0; intfs[i]; i++)
    {
	ether_addr address;
	int fd;
	int self;

	(void) printf ("%s: ", intfs[i]);
	(void) fflush (stdout);

	if ((fd = ether_open (intfs[i], 0xf0f0, (ether_addr *) NULL)) < 0)
	    perror ("open");
	else
	{
	    struct in_addr ipaddr;
	    char hostname2[MAXHOSTNAMELEN + 1];

	    (void) setreuid (0, uid);

	    if (ether_address (fd, &address) == NULL)
		perror ("address");
	    else
		(void) printf ("%s\n", ether_ntoa (&address));

	    hostname2[MAXHOSTNAMELEN] = '\0';
	    if (ether_e2host (&address, hostname2) == NULL)
	    {
		(void) fprintf (stderr, "ether_e2host failed\n");
		if (ether_e2ip (&address, &ipaddr) == NULL)
		    (void) fprintf (stderr, "ether_e2ip failed\n");
	    }
	    else
	    {
		if (ether_e2ip (&address, &ipaddr) == NULL)
		    (void) fprintf (stderr, "ether_e2ip failed\n");
		else
		    (void) printf ("%s: %s\n", hostname2, inet_n2a (ipaddr));
	    }

	    self = ether_bcast_self (fd);

	    packet.pktbuf = "dlrow ,olleh";
	    packet.pktlen = 13;
	    bcopy ((char *) &ether_bcast_addr, (char *) &packet.dest,
		   sizeof (address));
	    if (ether_write (fd, &packet) < 0)
		perror ("ether_write");

	    if (ether_blocking (fd, 0))
		perror ("ether_blocking");

	    (void) sleep (1);

	    packetv.iov = iov2;
	    packetv.iovcnt = sizeof (iov2) / sizeof (struct iovec);

	    if (ether_readv (fd, &packetv) < 0)
	    {
		if (errno != EAGAIN)
		    perror ("ether_readv");
		else if (self == 0)
		    (void)
			(void) printf ("%s",
				  "interface cannot receive own broadcasts\n");
		else
		    (void) fprintf (stderr, "%s %s\n",
				    "interface cannot receive own broadcasts",
				    "but thinks that it can!");
	    }
	    else if (strcmp (helloworld, "dlrow ,olleh"))
		(void) fprintf (stderr,
				"bcast_self test received garbled packet\n");

	    else if (bcmp ((char *) &packetv.src, (char *) &address,
			   sizeof (ether_addr)))
		    (void) fprintf (stderr, "WARNING: source address %s!\n",
				    ether_e2a (&packetv.src, (char *) 0));
	    else if (self == 1)
	    {
		(void) printf ("%s",
			       "interface will receive own broadcasts\n");
	    }
	    else
	    {
		(void) fprintf (stderr, "%s %s\n",
				"interface will receive own broadcasts",
				"but doesn't think that it can!");
	    }

	    self = ether_send_self (fd);

	    packetv.iov = iov;
	    packetv.iovcnt = sizeof (iov) / sizeof (struct iovec);

	    bcopy ((char *) &address, (char *) &packetv.dest, sizeof (address));
	    if (ether_writev (fd, &packetv) < 0)
		perror ("ether_writev");

	    (void) sleep (1);

	    packet.pktbuf = NULL;
	    if (ether_read (fd, &packet) < 0)
	    {
		if (errno != EAGAIN)
		    perror ("ether_read");
		else if (self == 0)
		    (void) printf ("%s",
				   "interface cannot send packets to self\n");
		else
		    (void) fprintf (stderr, "%s %s\n",
				    "interface cannot send packets to self",
				    "but thinks that it can!");
	    }
	    else if (strcmp (packet.pktbuf, "hello, world"))
		(void) fprintf (stderr,
				"send_self test received garbled packet\n");

	    else if (!bcmp ((char *) &packetv.src, (char *) &address,
			    sizeof (ether_addr)))
		    (void) fprintf (stderr, "WARNING: source address %s!\n",
				    ether_ntoa (&packetv.src));

	    else if (self == 1)
	    {
		(void) printf ("%s", "interface can send packets to self\n");
	    }
	    else
	    {
		(void) fprintf (stderr, "%s %s\n",
				"interface can send packets to self",
				"but doesn't think that it can!");
	    }

	    (void) close (fd);

	    (void) setreuid (uid, 0);

	    if ((fd = ether_open (intfs[i], 0xf0f0, &multicast)) < 0)
		(void) printf (
			   "interface does not support multicast reception\n");
	    else
	    {
		(void) setreuid (0, uid);

		self = ether_mcast_self (fd);

		packet.pktbuf = "dlrow ,olleh";
		packet.pktlen = 13;
		bcopy ((char *) &multicast, (char *) &packet.dest,
		       sizeof (address));
		if (ether_write (fd, &packet) < 0)
		    perror ("ether_write");

		if (ether_blocking (fd, 0))
		    perror ("ether_blocking");

		(void) sleep (1);

		packetv.iov = iov2;
		packetv.iovcnt = sizeof (iov2) / sizeof (struct iovec);

		if (ether_readv (fd, &packetv) < 0)
		{
		    if (errno != EAGAIN)
			perror ("ether_readv");
		else if (self == 0)
		    (void)
			(void) printf ("%s",
				  "interface cannot receive own multicasts\n");
		else
		    (void) fprintf (stderr, "%s %s\n",
				    "interface cannot receive own multicasts",
				    "but thinks that it can!");
		}
		else if (strcmp (helloworld, "dlrow ,olleh"))
		    (void) fprintf (stderr,
				  "mcast_self test received garbled packet\n");

		else if (bcmp ((char *) &packetv.src, (char *) &address,
			       sizeof (ether_addr)))
		    (void) fprintf (stderr, "WARNING: source address %s!\n",
				    ether_ntoa (&packetv.src));

		else if (self == 1)
		{
		    (void) printf ("%s",
				   "interface will receive own multicasts\n");
		}
		else
		{
		    (void) fprintf (stderr, "%s %s\n",
				    "interface will receive own multicasts",
				    "but doesn't think that it can!");
		}

		(void) setreuid (uid, 0);
	    }
	}
    }

    if (ether_cmp (&multicast, ether_aton (mcastname1)))
	(void) fprintf (stderr, "ether_aton failed (%s)\n",
			ether_ntoa (ether_aton (mcastname1)));

    if (ether_cmp (&multicast, ether_a2e (mcastname2, &eaddress)))
	(void) fprintf (stderr, "ether_a2e failed (%s)\n",
			ether_ntoa (&eaddress));

    return (0);
}

char *
inet_n2a (addr)
struct in_addr addr;
{
#ifdef lint
    char *sprintf ();
#endif
    static char buffer[16];
    unsigned char *bytes;

    bytes = (unsigned char *) &addr;
    (void) sprintf (buffer, "%d.%d.%d.%d",
		    bytes[0], bytes[1], bytes[2], bytes[3]);

    return (buffer);
}
