/* $Id: nit4intaddr.c,v 2.1 89/10/23 15:42:56 dupuy Exp $ */

#include <strings.h>			/* strncpy */
#include <sys/file.h>			/* O_RDWR */
#include <sys/types.h>			/* NIOCBIND (u_long) */
#include <sys/time.h>			/* NIOCBIND (timeval) */
#include <sys/ioccom.h>			/* ioctl */
#include <sys/socket.h>			/* ifreq (sockaddr) */

#include <net/if.h>			/* ifreq */
#include <net/nit_if.h>			/* NIOCBIND */

#include "libether.h"

extern int errno;

#ifndef NIT_DEV
#define NIT_DEV "/dev/nit"
#endif

ether_addr _ether_localaddr;		/* shared with ether_address() */
int _ether_haveaddress;			/* shared with ether_address() */

/*
 * Returns the local ethernet address for an ethernet interface.  The result
 * is stored in the structure given by address; if none is given, malloc is
 * used to allocate space.  Sun systems have the "feature" that all ethernet
 * interfaces are set to the same address (taken from the ID PROM).  So we can
 * get the answer once, and use it forever.
 */

ether_addr *
ether_intfaddr (intf, address)
char *intf;
ether_addr *address;
{
    if (!_ether_haveaddress)
    {
	int fd;
	struct ifreq ifr;
	int saved_errno;

	if ((fd = open (NIT_DEV, O_RDWR)) < 0)
	{
#ifdef DEBUG
	    perror (NIT_DEV);
#endif
	    return (0);
	}

	(void) strncpy (ifr.ifr_name, intf, sizeof (ifr.ifr_name));

	if (ioctl (fd, NIOCBIND, (char *) &ifr) < 0)
	{
	    saved_errno = errno;
#ifdef DEBUG
	    perror ("ether_intfaddr: ioctl NIOCBIND");
#endif
	    (void) close (fd);
	    errno = saved_errno;
	    return (0);
	}

	address = ether_address (fd, address);

	saved_errno = errno;
	(void) close (fd);
	errno = saved_errno;

	return (address);
    }

    if (address == 0)
	address = (ether_addr *) malloc (sizeof (ether_addr));

    if (address != 0)
	*address = _ether_localaddr;

    return (address);
}
