/* $Id: nit3read.c,v 2.1 89/10/23 15:42:53 dupuy Exp $ */

#include "libether.h"

/*
 * Reads and returns a single packet, filling in all fields.  If pktbuf is
 * NULL, a buffer is allocated for it.	If pktbuf is not NULL, the function
 * assumes that pktbuf is large enough to hold pktlen bytes.  Since read() may
 * return several packets at a time, we have to buffer them as well.  Since
 * socket based nit doesn't handle multicast addresses, we have to check them
 * at the user level.
 *
 * NOTE - the buffering code is not re-entrant, although different fd's will
 * not conflict.
 */

int
ether_read (fd, packet)
int fd;
ether_packet *packet;
{
    char *pbuf;
    int bytes;

    if ((bytes = _ether_next_packet (fd, &pbuf)) < 0)
	return (-1);

    bcopy (pbuf, (char *) packet, ETHER_PKT);
    pbuf += ETHER_PKT;

    if (packet->pktbuf == 0)
    {
	packet->pktlen = bytes;
	if ((packet->pktbuf = (char *) malloc ((unsigned) bytes)) == 0)
	    return (-1);
    }

    bcopy (pbuf, packet->pktbuf,
	   (int) ((packet->pktlen > bytes) ? bytes : packet->pktlen));

    if (packet->pktlen > bytes)
	packet->pktlen = bytes;

    return (bytes);
}
