/* $Id: etherhe2e.c,v 2.1 89/10/24 17:53:20 dupuy Exp $ */

#include <sys/types.h>			/* in_addr (u_short) */
#include <sys/socket.h>			/* AF_INET */
#include <netinet/in.h>			/* in_addr */

#include <netdb.h>			/* hostent */
#include <errno.h>			/* EAFNOSUPPORT */

extern int errno;

#include "libether.h"

/*
 * derived from ethertools/hetoea.c
 *
 * Copyright (c) 1988 Philip L. Budne and The Trustees of Boston University
 * All Rights Reserved
 *
 * Permission is granted to any individual or institution to use, copy, or
 * redistribute this software so long as it is not sold for profit, provided
 * that this notice and the original copyright notices are retained.  Boston
 * University makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

ether_addr *
ether_hostent2e (host, addr)
struct hostent *host;
ether_addr *addr;
{
    char **hlist;
    int allocated = 0;

    if (addr == 0)
    {
	addr = (ether_addr *) malloc (sizeof (ether_addr));
	allocated++;
    }

#if ETHERDB
    if (ether_hostton (host->h_name, addr) == 0)
	return (addr);			/* official name worked */

    for (hlist = host->h_aliases; *hlist != 0; hlist++)
	if (ether_hostton (*hlist, addr) == 0)
	    return (addr);
#endif

    /*
     * Try to resolve the IP addresses if possible.  We would try this first
     * if proxy ARP didn't cause such confusion.
     */

    if (host->h_addrtype == AF_INET)
    {
	struct in_addr haddr;
	int saved_errno = 0;

#ifdef h_addr				/* we have a list */
	for (hlist = host->h_addr_list; *hlist != 0; hlist++)
	{
	    bcopy (*hlist, (char *) &haddr, sizeof (haddr));
#else
	    bcopy (host->h_addr, (char *) &haddr, sizeof (haddr));
#endif
	    if (ether_ip2e (&haddr, addr))
		return (addr);
	    else if (saved_errno == 0)
		saved_errno = errno;
	    else if (errno == EHOSTDOWN)
		saved_errno = errno;
#ifdef h_addr
	}
#endif
	errno = saved_errno;		/* restore "best" error message */
    }
    else
	errno = EAFNOSUPPORT;		/* not quite the right error message */

    if (allocated)
	free ((char *) addr);

    return (0);
}
