/* $Id: dliintaddr.c,v 2.1 89/10/23 15:41:58 dupuy Exp $ */

#include <errno.h>

extern int errno;

#include "libether.h"

/*
 * Returns the local ethernet address for the ethernet interface.  The result
 * is stored in the structure given by address; if none is given, malloc is
 * used to allocate space.
 */

ether_addr *
ether_intfaddr (intf, address)
char *intf;
ether_addr *address;
{
    int fd;
    unsigned short proto = 0xffff;
    int saved_errno;

    do
	if ((fd = ether_open (intf, proto--, (ether_addr *) 0)) < 0)
	{
	    if (errno == EADDRINUSE)
		continue;
	    return (0);
	}				/* constant argument to NOT ??? */
    while (fd < 0 && proto >= ETHER_MINTYPE);

    address = ether_address (fd, address);

    saved_errno = errno;
    (void) close (fd);
    errno = saved_errno;

    return (address);
}
