/* $Id: ctp.h,v 1.2 89/10/24 17:54:33 dupuy Exp $ */

/*
 * derived from ethertools/ctp.h
 * 
 * Copyright (c) 1988 Philip L. Budne and The Trustees of Boston University All
 * Rights Reserved
 * 
 * Permission is granted to any individual or institution to use, copy, or
 * redistribute this software so long as it is not sold for profit, provided
 * that this notice and the original copyright notices are retained.  Boston
 * University makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

/*
 * Make sure we have the fd_set macros
 */

#ifndef FD_SETSIZE
#define FD_SETSIZE 256			/* Ultrix uses a chintzy 64 */
#endif

#include <sys/param.h>

#ifndef FD_SET				/* no fd_set macros in sys/types.h */

#if NOFILE > 32				/* assumes we included sys/param.h */

#ifndef NBBY
#define NBBY	8			/* number of bits in a byte */
#endif

typedef long fd_mask;
#define NFDBITS (sizeof(fd_mask) * NBBY)/* bits per mask */
#ifndef howmany
#define howmany(x, y)	(((x)+((y)-1))/(y))
#endif

#define fd_set real_fd_set

typedef struct real_fd_set
{
    fd_mask fds_bits[howmany (FD_SETSIZE, NFDBITS)];
}           real_fd_set;

#define FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))

#define param(s)	((int *) (s))

#else					/* NOFILE <= 32 */

/*
 * Create the fd_set type, just in case this isn't 4.2.
 */

#define fd_set real_fd_set

typedef struct real_fd_set
{
    long fds_bits[1];
}           real_fd_set;

#define FD_SET(f,s)	((s)->fds_bits[0] |= (1 << (f)))
#define FD_CLR(f,s)	((s)->fds_bits[0] &= ~(1 << (f)))
#define FD_ISSET(f,s)	((s)->fds_bits[0] & (1 << (f)))
#define FD_ZERO(s)	((s)->fds_bits[0] = 0)

#define param(s)	((int *) (s))

#endif					/* NOFILE > 32 */

#else

#define param(s)	((fd_set *) (s))

#endif					/* FD_SET */

/*
 * CTP Protocol constants
 */

#define CTPTYPE 0x9000

#define CTP_REP 1			/* in VAX byte order */
#define CTP_FWD 2

/*
 * CTP packet structures
 */

#include <sys/time.h>
#include "ether.h"

typedef struct ctppacket		/* CTP packet layout */
{
    int :0;				/* force long alignment for timeval */
    unsigned short skip;		/* CTP skip in VAX byte order */

    char data[ETHER_MAX - sizeof (unsigned short)];
}
          ctp_packet;

typedef struct ctpforward		/* forward subpacket */
{
    unsigned short function;		/* CTP_FWD */
    ether_addr addr;
}
           ctp_forward;

typedef struct ctpreply			/* reply subpacket */
{
    unsigned short function;		/* CTP_REP */

    /* The following is data that we use for own purposes */

    unsigned short pid;			/* pid of sender -- not swapped */
    unsigned short seq;			/* sequence number -- not swapped */

    short sendt[4];			/* really struct timeval */
}
         ctp_reply;

#define MAXPATH ((ETHER_MAX - sizeof (ctp_reply) - 2)  / sizeof (ctp_forward))
