/* $Id: libether.h,v 2.1 89/10/23 15:42:44 dupuy Exp $ */

/* Internal definitions for ethernet access library */

#include "ether.h"			/* get interface definitions */

#define MAXNUMIF 16			/* maximum number of interfaces */

#define ETHER_BUFFERS	5		/* for socket based NIT interface */
#define ETHER_BUFSIZ \
 (ETHER_BUFFERS * (ETHER_PKT + ETHER_MAX + (2 * sizeof (struct nit_hdr))))

#define ALIGNSIZE	(sizeof (int))
#define pad(x)		((ALIGNSIZE - ((unsigned)(x)) % ALIGNSIZE) % ALIGNSIZE)

#define address_check(dest) \
 (ETHER_MCAST (dest) \
  && bcmp ((char *)(dest), (char *) &ether_bcast_addr, sizeof (ether_addr)) \
  && bcmp ((char *)(dest), (char *) &_ether_multi_addrs[fd], \
	   sizeof (ether_addr)))

#ifdef __STDC__

extern char *malloc (unsigned size);

extern int _ether_arpscan (ether_addr *addr, struct in_addr *ipaddr);
extern int _ether_localif (ether_addr *addr, struct in_addr *ipaddr);
#ifdef RARP
extern int _ether_rarpprobe (ether_addr *addr, struct in_addr *ipaddr);
#endif

#else

#ifdef lint

#ifndef htons

extern unsigned short htons ();

#endif

#ifdef ultrix

extern void bzero ();
extern void bcopy ();
extern void free ();
extern void perror ();

#endif

extern double *dalloc ();
#define malloc dalloc

#else

extern char *malloc ();

#endif /* lint */

#endif /* __STDC__ */
