/* $Id: nit4write.c,v 2.0 89/10/20 19:02:47 dupuy Exp $ */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stropts.h>

#include "libether.h"

extern unsigned _ether_types[FD_SETSIZE];

#define ether_type (_ether_types[fd])

/*
 * Writes a single packet, filling src and type fields.
 */

int
ether_write (fd, packet)
int fd;
ether_packet *packet;
{
    struct sockaddr sa;
    struct strbuf cbuf;
    struct strbuf dbuf;

    sa.sa_family = AF_UNSPEC;
    bcopy ((char *) packet, sa.sa_data, ETHER_TYPE);

    if (ether_type != ETHER_ALLTYPES)
    {
	sa.sa_data[12] = (ether_type >> 8) & 0xff;
	sa.sa_data[13] = ether_type & 0xff;
    }

    cbuf.maxlen = cbuf.len = sizeof (sa);
    cbuf.buf = (char *) &sa;

    /*
     * The interface output routines will paste the ether header back onto the
     * front of the message.
     */

    dbuf.len = packet->pktlen;
    dbuf.buf = packet->pktbuf;

    return (putmsg (fd, &cbuf, &dbuf, 0));
}
