/* $Id: ethere2h.c,v 2.1 89/10/23 15:42:30 dupuy Exp $ */

#include <sys/param.h>			/* MAXHOSTNAMELEN */
#include <sys/socket.h>			/* AF_INET */
#include <netinet/in.h>			/* in_addr */

#include <netdb.h>			/* hostent */
#include <strings.h>			/* strncpy */

#include "libether.h"

static char *
ip2host (addr, hname)
struct in_addr *addr;
char *hname;
{
#ifdef lint
    char *sprintf ();
#endif
    struct hostent *host;

    /*
     * Unfortunately, gethostbyaddr is not reentrant.  It should be.
     */

    if (host = gethostbyaddr ((char *) addr, sizeof (struct in_addr), AF_INET))
	(void) strncpy (hname, host->h_name, MAXHOSTNAMELEN);
    else				/* use dotted-quad notation */
	(void) sprintf (hname, "[%d.%d.%d.%d]",
			(addr->s_addr >> 24) & 0xff,
			(addr->s_addr >> 16) & 0xff,
			(addr->s_addr >> 8) & 0xff,
			addr->s_addr & 0xff);

    return (hname);
}

char *
ether_e2host (addr, hname)
ether_addr *addr;
char *hname;
{
    struct in_addr ipaddr;
    int allocated = 0;

    if (hname == NULL)
    {
	hname = (char *) malloc (MAXHOSTNAMELEN);
	allocated++;
    }

    if (hname == NULL)
	return (NULL);

#ifdef ETHERDB
    if (ether_ntohost (hname, addr) == 0)
	return (hname);
#endif

    /*
     * At this point we would like to ioctl the arp table and see if we
     * already have an entry for this ethernet address.	 But the arp table is
     * hashed by protocol address, not by ethernet address, so we have to
     * grovel though /dev/kmem and look at all the entries.  And after that,
     * we may not find an entry for the ethernet address anyhow.
     */

    if (_ether_arpscan (addr, &ipaddr))
	return (ip2host (&ipaddr, hname));

    /*
     * Since the kernel doesn't keep an entry for the local interfaces in the
     * arp table, we also check the ethernet addresses for each of those
     * looking for a match.
     */

    if (_ether_localif (addr, &ipaddr))
	return (ip2host (&ipaddr, hname));

#ifdef RARP

    /*
     * Now the only alternative left is to use RARP (via ether_open, etc.) to
     * try to get the IP address.  Unfortunately, most machines won't RARP for
     * themselves, so this isn't terribly useful either.  Especially since we
     * probably need superuser privilege to call ether_open!
     */

    if (_ether_rarpprobe (addr, &ipaddr))
	return (ip2host (&ipaddr, hname));
#endif

    if (allocated)			/* sigh, dispose it */
	(void) free (hname);

    return (NULL);			/* too bad, we failed */
}
