/* $Id: enetwritev.c,v 2.2 89/10/24 17:53:10 dupuy Exp $ */

#include <sys/types.h>			/* iovec (caddr_t) */
#include <sys/uio.h>			/* iovec */

#include "libether.h"

#ifdef __GNUC__
#define alloca __builtin_alloca
#else
#ifdef lint
extern double *dalloca ();
#define alloca dalloca
#else
#ifdef sparc
#include <alloca.h>
#endif
extern char *alloca ();
#endif
#endif

extern unsigned _ether_types[FD_SETSIZE];

#define ether_type (_ether_types[fd])

#define HEADER	0
#define USER	1

/*
 * Writes a single packet, filling src and type fields.	 We have to fill in
 * the src field in user space, since the enetfilter doesn't do it for us, and
 * at least some VAX interface devices don't do it either.
 */

int
ether_writev (fd, packet)
int fd;
ether_vec *packet;
{
    int count = 1 + packet->iovcnt;
    struct iovec *iov =
	(struct iovec *) alloca (sizeof (struct iovec) * count);

    iov[HEADER].iov_len = ETHER_PKT;
    iov[HEADER].iov_base = (char *) packet;

    (void) bcopy ((char *) packet->iov, (char *) &iov[USER],
		  (int) packet->iovcnt * sizeof (struct iovec));

    if (ether_type != ETHER_ALLTYPES)
    {
	packet->type[0] = (ether_type >> 8) & 0xff;
	packet->type[1] = ether_type & 0xff;
    }

    (void) ether_address (fd, (ether_addr *) &packet->src);

    return (writev (fd, iov, count));
}
