#
# Indirect GNU makefile for ethernet interface library
#

# Get pattern rules for %.ps

include ../GNUmake.config

# This builds machine-dependent components for the ethernet interface library

# VPATH directives

vpath %.h ../src
vpath %.c ../src:../tests
vpath %.3n ..


# Configuration

NIT := $(shell ls /usr/include/net/nit.h 2>/dev/null)
NIT4 := $(shell ls /dev/nit 2>/dev/null)
ENET := $(shell ls /dev/enet/ 2>/dev/null)

# Software components

HDRS = ether.h libether.h

SRCS = etheraddr.c etherints.c ethere2a.c ethera2e.c etherarp.c etherlocal.c \
 ethere2ip.c etherip2e.c ethere2h.c etherh2e.c etherhe2e.c

ALLSRCS := $(SRCS) \
 etherblock.c etherread.c etherreadv.c nitaddr.c \
 nit4self.c nit4intaddr.c nit4open.c nit4write.c nit4writev.c \
 nit3self.c nit3intaddr.c nit3open.c \
 nit3read.c nit3readv.c nit3write.c nit3writev.c \
 dliaddr.c dliself.c dliintaddr.c dliopen.c \
 dliread.c dlireadv.c dliwrite.c dliwritev.c \
 enetblock.c enetaddr.c enetself.c enetintaddr.c enetopen.c \
 enetwrite.c enetwritev.c

ifneq ($(NIT4),)
SRCS := $(SRCS) etherblock.c etherread.c etherreadv.c \
 nitaddr.c nit4self.c nit4intaddr.c nit4open.c nit4write.c nit4writev.c
DEFINES := $(DEFINES) -DETHERDB
else
ifneq ($(NIT),)
SRCS := $(SRCS) etherblock.c nitaddr.c nit3self.c nit3intaddr.c \
 nit3open.c nit3read.c nit3readv.c nit3write.c nit3writev.c
DEFINES := $(DEFINES) -DETHERDB
endif
endif

ifneq ($(findstring ultrix,$(SYSTEM)),)
SRCS := $(SRCS) etherblock.c dliaddr.c dliself.c dliintaddr.c \
 dliopen.c dliread.c dlireadv.c dliwrite.c dliwritev.c
DEFINES := $(DEFINES) -DETHERDB
else
ifneq ($(ENET),)
SRCS := $(SRCS) etherread.c etherreadv.c enetblock.c enetaddr.c \
 enetintaddr.c enetself.c enetopen.c enetwrite.c enetwritev.c
#INCLUDES = -I../enet/4.3
endif
endif

# Compilation flags used

ifeq ($(findstring gcc,$(CC)),)

CFLAGS = $(OPT) $(DEFINES) $(INCLUDES)

else

CFLAGS = $(OPTG) $(DEFINES) $(INCLUDES)

endif

INCLUDES := -I../src $(INCLUDES)

OBJS = $(SRCS:.c=.o)

LINTFLAGS = -bhuxz

# Default dependency - remake all out of date object files

.PHONY: default all

default: all

all: libether.a

libether.a: $(OBJS)
ifeq ($(findstring t,$(MAKEFLAGS)),)
	ar curv $@ $(OBJS)
	ranlib $@
else
	@echo $(MAKE) > /dev/null
	touch $@
	ranlib -t $@
endif

etheraddr.o: etheraddr.c
	$(CC) $(CFLAGS) -R -c $< $(OUTPUT_OPTION)

test: ethertest
	./ethertest

ethertest: ethertest.o libether.a

ctp: ctp.o $(LIBDIR)/libether.a

$(OBJS): $(HDRS)


# Installation

install: $(LIBDIR)/libether.a $(INCDIR)/ether.h $(MANDIR)/man3/ether.3n

# Fluff test

.PHONY: lint

lint: $(SRCS) ethertest.c
	-$(LINT) $(LINTFLAGS) $(DEFINES) $(INCLUDES) -I. $?


# Vgrind formatted listing

LISTS = $(ALLSRCS:.c=.ps) $(HDRS:.h=.ps) index.ps

.PHONY: listing

listing: index $(LISTS)

index.ps: index
	sort -fu -o index index
	$(VGRIND) -t -x index > index.ps

index: /dev/null
	ctags -tv $(SRCS) $(HDRS) >> index 2>/dev/null


# Utility operations

.PHONY: clean cleanlists realclean

clean:
	rm -f $(OBJS) libether.a ethertest.o ethertest ctp.o ctp

cleanlists:
	rm -f $(LISTS) index

realclean: clean cleanlists
