/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


	/* Element types */
#define LT		1
#define LE		2
#define GT		3
#define GE		4
#define EQ		5
#define NE		6
#define AND		7
#define OR		8
#define NOT		9
#define PLUS	10
#define MINUS	11
#define MUL		12
#define DIV		13
#define GETS	14
#define LPAREN	15
#define RPAREN	16
#define NAME	17
#define STRING	18
#define FLOAT	19
#define INT		20
#define BOOL	21
#define ERROR	22

#define ENDMARKER	-1

#define MAX_EXPR_LIST		512		/* Max elements in an expression */
#define MAX_STRING			1024	/* Max lenght of a name or string */

#define f_val val.float_val
#define i_val val.integer_val
#define s_val val.string_val
#define b_val val.integer_val

typedef struct {
	int		type;
	union {
		int		integer_val;	/* Integer value */
		float	float_val;		/* Floating point value */
		char	*string_val;	/* String value */
	} val;
} ELEM;

typedef struct {
	int		len;
	int		max_len;
	ELEM	**data;
} EXPR;
#define EXPR_INCR 25

typedef struct {
	int		top;
	ELEM	*data[MAX_EXPR_LIST];
} STACK;

typedef struct {
	int		len;
	int		max_len;
	EXPR	**data;
} CONTEXT;

#define IN_STACK	1
#define IN_COMING	2
