/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include "condor_sys.h"
#include <sys/types.h>
#include <sys/mman.h>

#ifdef SUNOS40
#define RTYPE	caddr_t
#else SUNOS40
#define RTYPE	int
#endif SUNOS40

RTYPE
mmap( addr, len, prot, share, fd, pos )
caddr_t addr;
int len, prot, share, fd;
off_t pos;
{
	RTYPE rval;

	if( Syscalls & SYS_LOCAL ) {
		rval = (RTYPE)syscall(SYS_mmap, addr, len, prot, share, fd, pos);
	} else {
		rval = (RTYPE)REMOTE_syscall(CONDOR_mmap, addr, len, prot,
															share, fd, pos);
	}

	return( rval );
}
