#include <stdio.h>
#include <ctype.h>

FILE *InFP, *OutFP;

int FoundIt = 0;
int EndOfFile = 0;

char InBuf[ BUFSIZ ];
int Index;

char *Name;
int NameLen;

main( argc, argv )
int argc;
char **argv;
{
	int i;

	if( argc != 4 ) {
		fprintf(stderr, "Usage: %s infile outfile name\n", *argv );
		exit( 1 );
	}

	InFP = fopen(argv[1], "r");
	if( InFP == NULL ) {
		perror(argv[1]);
		exit( 1 );
	}

	OutFP = fopen(argv[2], "w");
	if( OutFP == NULL ) {
		perror(argv[2]);
		exit( 1 );
	}

	Name = argv[3];
	NameLen = strlen(Name);

	InitInBuf();

	for(;;) {
		if( IsName() ) {
			for( i = 0; i < NameLen; i++ ) {
				if( islower(Name[i]) ) {
					put_one( Name[i] - ' ' );
				} else {
					put_one( Name[i] );
				}
			}
			FoundIt = 1;
			InitInBuf();
		} else {
			NextChar();
		}
	}
}

DoCleanup()
{
	(void) fclose( InFP );
	(void) fclose( OutFP );

	if( ! FoundIt ) {
		fprintf(stderr, "Could not find 'main'\n");
		exit( 1 );
	}

	exit( 0 );
}

char
get_one()
{
	int ch = fgetc(InFP);

	if( ch == EOF ) {
		EndOfFile = 1;
		return( (char) NULL );
	}

	return( (char) ch );
}

put_one( ch )
char ch;
{
	(void) fputc( (int) ch, OutFP );
}

InitInBuf()
{
	int i;

	for( Index = 0; Index < NameLen; Index++ ) {
		InBuf[Index] = get_one();
		if( EndOfFile ) {
			for( i = 0; i < Index; i++ ) {
				put_one( InBuf[i] );
			}
			DoCleanup();
		}
	}

	Index = 0;
}

NextChar()
{
	int i;

	put_one( InBuf[Index] );

	InBuf[Index] = get_one();
	if( EndOfFile ) {
		for( i = (Index+1) % NameLen; i != Index; i = (i+1) % NameLen ) {
			put_one( InBuf[i] );
		}

		DoCleanup();
	}

	Index = (Index + 1) % NameLen;
}

IsName()
{
	int i;

	for( i = 0; i < NameLen; i++ ) {
		if( InBuf[(Index+i) % NameLen] != Name[i] ) {
			return( 0 );
		}
	}

	return( 1 );
}
