/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <ctype.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "debug.h"
#include "except.h"
#include "trace.h"
#include "sched.h"
#include "expr.h"
#include "proc.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

XDR		*xdr_Init();
char	*index();

usage( str )
char	*str;
{
	fprintf( stderr, "Usage: %s cluster.proc\n", str );
	exit( 1 );
}

main( argc, argv )
int		argc;
char	*argv[];
{
	int			sock = -1;
	int			cmd;
	XDR			xdr, *xdrs = NULL;
	char		hostname[512];
	PROC_ID		job_id;
	char		*cluster_p;
	char		*proc_p;

	if( argc != 2 ) {
		usage( argv[0] );
	}

	config( argv[0], (CONTEXT *)0 );

	cluster_p = argv[1];
	proc_p = index( argv[1], '.' );
	if( proc_p ) {
		proc_p += 1;
	} else {
		usage( argv[0] );
	}

	if( !isdigit(cluster_p[0]) || (!isdigit(proc_p[0]) && proc_p[0] != '-') ) {
		EXCEPT( "%s: invalid job id", argv[1] );
	}

	job_id.cluster = atoi( cluster_p );
	job_id.proc = atoi( proc_p );


	if( gethostname(hostname,sizeof(hostname)) < 0 ) {
		EXCEPT( "gethostname failed" );
	}

		/* Connect to the specified host */
	if( (sock = do_connect(hostname, "condor_schedd", SCHED_PORT)) < 0 ) {
		dprintf( D_ALWAYS, "Can't connect to schedd on %s\n", hostname );
		exit( 1 );
	}
	xdrs = xdr_Init( &sock, &xdr );
	xdrs->x_op = XDR_ENCODE;

	cmd = KILL_FRGN_JOB;
	ASSERT( xdr_int(xdrs, &cmd) );
	ASSERT( xdr_proc_id(xdrs, &job_id) );
	ASSERT( xdrrec_endofrecord(xdrs,TRUE) );

	printf( "Sent KILL_FRGN_JOB command to schedd on %s\n", hostname );

	exit( 0 );
}

SetSyscalls(){}
