/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#include "condor_sys.h"

#ifndef MIPS
#include "_updateckpt.other.c"
#else MIPS
#include "_updateckpt.mips.c"
#endif MIPS

_mkckpt( ckptfile, objfile )
char *ckptfile, *objfile;
{
	register int objfd, ckptfd;
	register int len = 0, cc;
	register int i;
	int ssize;
	char buf[ 4 * 1024 ];
#ifdef CM_JOB
	CKPTMAP cm;
	JOB j;
#endif CM_JOB

	/*
	**	Make sure to do local calls...
	*/
	(void) SetSyscalls( SYS_LOCAL | SYS_UNRECORDED );

	objfd = open( objfile, O_RDONLY, 0 );
	if( objfd < 0 ) {
		EXCEPT("open %s", objfile);
	}

	ckptfd = open( ckptfile, O_CREAT|O_TRUNC|O_WRONLY, 0777);
	if( ckptfd < 0 ) {
		EXCEPT("open %s", ckptfile);
	}

	for(;;) {
		cc = read(objfd, buf, sizeof(buf));
		if( cc < 0 ) {
			EXCEPT("read %s: len = %d", objfile, len);
		}

		if( write(ckptfd, buf, cc) != cc ) {
			EXCEPT("write %s: cc = %d, len = %d", ckptfile, cc, len);
		}

		len += cc;

		if( cc != sizeof(buf) ) {
			break;
		}
	}

#ifdef CM_JOB
	bzero( (char *)&cm, sizeof(CKPTMAP) );
	initjob( &j );

	cm.cm_segs[ CM_JOB ].cs_pos = len;
	cm.cm_segs[ CM_JOB ].cs_len = sizeof(JOB);

	if( write(ckptfd, (char *) &j, sizeof(JOB)) != sizeof(JOB) ) {
		EXCEPT("write %s: JOB", ckptfile);
	}

	cm.cm_segs[ CM_SEGMAP ].cs_pos = len + sizeof(JOB);
	cm.cm_segs[ CM_SEGMAP ].cs_len = sizeof(CKPTMAP);

	/*
	**	Before writing out the checkpoint segment map,
	**	convert to network order.
	*/
	for( i = 0; i < NCKPTSEGS; i++ ) {
		cm.cm_segs[i].cs_fd  = 0;
		cm.cm_segs[i].cs_pos = TO_NET_ORDER(cm.cm_segs[i].cs_pos);
		cm.cm_segs[i].cs_len = TO_NET_ORDER(cm.cm_segs[i].cs_len);
	}

	if( write(ckptfd, (char *) &cm, sizeof(CKPTMAP)) != sizeof(CKPTMAP) ) {
		EXCEPT("write %s: CKPTMAP", ckptfile);
	}
#else CM_JOB
	/*
	**	For completeness, write the size of the stack at the end
	**	of the file.  Make it zero to indicate that there is no stack...
	*/
	ssize = htonl(0);

	if( write(ckptfd, (char *) &ssize, sizeof(ssize)) != sizeof(ssize) ) {
		EXCEPT("write %s: ssize", ckptfile);
	}
#endif CM_JOB

	(void)close( objfd );
	(void)close( ckptfd );
}
