/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


/*
** This program just copies an input file to an output file.  It test
** stdio input and output, as well as use of argc and argv.
*/

#include <stdio.h>

main( argc, argv)
int		argc;
char	*argv[];
{
	register int ch;
	FILE	*src, *dst;

	if( argc != 3 ) {
		usage( argv[0] );
	}

	if( (src=fopen(argv[1],"r")) == NULL ) {
		fprintf( stderr, "Can't open \"%s\" for reading\n", argv[1] );
		exit( 1 );
	}

	if( (dst=fopen(argv[2],"w")) == NULL ) {
		fprintf( stderr, "Can't open \"%s\" for writeing\n", argv[2] );
		exit( 1 );
	}


	while( (ch = getc(src)) != EOF ) {
		(void)putc( ch, dst );
	}

	exit( 0 );
}

usage( name )
char	*name;
{
	fprintf( stderr, "Usage: %s infile outfile\n", name );
	exit( 1 );
}
