/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <rpc/types.h>
#include <rpc/xdr.h>
#include "expr.h"

snd_string( xdrs, val, end_of_record )
XDR		*xdrs;
char	*val;
int		end_of_record;
{
	xdrs->x_op = XDR_ENCODE;
	if( !xdr_mywrapstring(xdrs,&val) ) {
		return FALSE;
	}

	if( end_of_record ) {
		if( !xdrrec_endofrecord(xdrs,TRUE) ) {
			return FALSE;
		}
	}

	return TRUE;
}

rcv_string( xdrs, val, end_of_record )
XDR		*xdrs;
char	**val;
int		end_of_record;
{
	xdrs->x_op = XDR_DECODE;
	if( !xdr_mywrapstring(xdrs,val) ) {
		return FALSE;
	}

	if( end_of_record ) {
		if( !xdrrec_skiprecord(xdrs) ) {
			return FALSE;
		}
	}

	return TRUE;
}

snd_context( xdrs, val, end_of_record )
XDR		*xdrs;
CONTEXT	*val;
int		end_of_record;
{
	xdrs->x_op = XDR_ENCODE;
	if( !xdr_context(xdrs,val) ) {
		return FALSE;
	}

	if( end_of_record ) {
		if( !xdrrec_endofrecord(xdrs,TRUE) ) {
			return FALSE;
		}
	}

	return TRUE;
}

snd_int( xdrs, val, end_of_record )
XDR		*xdrs;
int		val;
int		end_of_record;
{
	xdrs->x_op = XDR_ENCODE;
	if( !xdr_int(xdrs,&val) ) {
		return FALSE;
	}

	if( end_of_record ) {
		if( !xdrrec_endofrecord(xdrs,TRUE) ) {
			return FALSE;
		}
	}

	return TRUE;
}

rcv_int( xdrs, val, end_of_record )
XDR		*xdrs;
int		*val;
int		end_of_record;
{
	xdrs->x_op = XDR_DECODE;
	if( !xdr_int(xdrs,val) ) {
		return FALSE;
	}
	if( end_of_record ) {
		if( !xdrrec_skiprecord(xdrs) ) {
			return FALSE;
		}
	}
	return TRUE;
}

rcv_context( xdrs, context, end_of_record )
XDR		*xdrs;
CONTEXT	*context;
int		end_of_record;
{
	xdrs->x_op = XDR_DECODE;
	if( !xdr_context(xdrs,context) ) {
		return FALSE;
	}

	if( end_of_record ) {
		if( !xdrrec_skiprecord(xdrs) ) {
			return FALSE;
		}
	}
	return TRUE;
}
