/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "trace.h"
#include "except.h"
#include "xdr_lib.h"
#include "proc.h"

#ifndef LINT
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */
#endif LINT

/*
** XDR routine for a PROC.
*/
xdr_proc( xdrs, proc )
XDR		*xdrs;
PROC	*proc;
{
	if( xdrs->x_op == XDR_FREE ) {
		xdr_free_proc( proc );
		return TRUE;
	}

	if( !xdr_proc_id(xdrs,&proc->id) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->owner,256) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->q_date) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->status) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->prio) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->notification) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->cmd,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->args,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->env,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->in,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->out,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->err,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->rootdir,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->iwd,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->requirements,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->preferences,MAXPATHLEN) )
		return FALSE;
	if( !xdr_rusage(xdrs,&proc->local_usage) )
		return FALSE;
	if( !xdr_rusage(xdrs,&proc->remote_usage) )
		return FALSE;
	return TRUE;
}

xdr_free_proc( proc )
PROC	*proc;
{
	if( proc->owner ) {
		free( proc->owner );
		proc->owner = NULL;
	}

	if( proc->cmd ) {
		free( proc->cmd );
		proc->cmd = NULL;
	}

	if( proc->args ) {
		free( proc->args );
		proc->args = NULL;
	}

	if( proc->env ) {
		free( proc->env );
		proc->env = NULL;
	}

	if( proc->in ) {
		free( proc->in );
		proc->in = NULL;
	}

	if( proc->out ) {
		free( proc->out );
		proc->out = NULL;
	}

	if( proc->err ) {
		free( proc->err );
		proc->err = NULL;
	}

	if( proc->rootdir ) {
		free( proc->rootdir );
		proc->rootdir = NULL;
	}

	if( proc->requirements ) {
		free( proc->requirements );
		proc->requirements = NULL;
	}

	if( proc->preferences ) {
		free( proc->preferences );
		proc->preferences = NULL;
	}
}

/*
** XDR routine for a PROC_ID.
*/
xdr_proc_id( xdrs, id )
XDR		*xdrs;
PROC_ID	*id;
{
	return xdr_int(xdrs,&id->cluster) && xdr_int(xdrs,&id->proc);
}
