/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <sys/types.h>
#include "debug.h"
#include "except.h"
#include "trace.h"

#ifndef LINT
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */
#endif LINT

XDR_Write( iohandle, buf, len )
int		*iohandle;
char	*buf;
u_int	len;
{
	register int cnt;
	int terrno = 0;
	extern errno;

	cnt = write(*iohandle, buf, (int)len);
	if( cnt < 0 ) {
		terrno = errno;
	}
	dprintf( D_XDR, "XDR_Write wrote %d bytes to fd %d\n", cnt, *iohandle );

	errno = terrno;
	return cnt;
}

XDR_Read( iohandle, buf, len )
int		*iohandle;
char	*buf;
u_int	len;
{
	int	status;
	int terrno = 0;
	extern errno;

	dprintf( D_XDR, "Calling XDR_Read, iohandle = %d\n", *iohandle );
	status = read(*iohandle,buf,(int)len);
	if( status <= 0 ) {
		terrno = errno;
		status = -1;
	}
	dprintf( D_XDR, "XDR_Read read %d bytes\n", status );

	errno = terrno;
	return status;
}
