/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/types.h>
#include <sys/time.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "trace.h"
#include "except.h"
#include "expr.h"
#include "clib.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

bool_t	xdr_elem(), xdr_string(), xdr_float(), xdr_int(), xdr_void(),
		xdr_mywrapstring(), xdr_elem_ptr();
EXPR	*create_expr();
ELEM	*create_elem();
CONTEXT	*create_context();


struct xdr_discrim arms[] = {
	NAME,		xdr_mywrapstring,
	STRING,		xdr_mywrapstring,
	FLOAT,		xdr_float,
	INT,		xdr_int,
	BOOL,		xdr_int,
	-99,		NULL,
};

xdr_elem( xdrs, elem )
XDR		*xdrs;
ELEM	*elem;
{
	return xdr_union(xdrs,&elem->type,&elem->val,arms,xdr_void);
}

xdr_elem_ptr( xdrs, pp )
XDR		*xdrs;
ELEM	**pp;
{
	return xdr_reference(xdrs,pp,sizeof(ELEM),xdr_elem);
}

xdr_expr( xdrs, expr )
XDR		*xdrs;
EXPR	*expr;
{
	int		i;

	if( !xdr_int(xdrs,&expr->len) )
		return FALSE;
	if( xdrs->x_op == XDR_DECODE ) {
		if( expr->data ) {
			free( (char *)expr->data );
		}
		expr->max_len = expr->len;
		expr->data = (ELEM **)calloc( (unsigned)expr->max_len, sizeof(ELEM *) );
	}
	for( i=0; i<expr->len; i++ ) {
		if( !xdr_elem_ptr(xdrs,&(expr->data[i])) ) {
			return FALSE;
		}
	}
	return TRUE;
}

xdr_expr_ptr( xdrs, pp )
XDR		*xdrs;
EXPR	**pp;
{
	EXPR	*create_expr();

	if( xdrs->x_op == XDR_DECODE ) {
		if( !*pp ) {
			*pp = create_expr();
		}
	}
	return xdr_expr( xdrs, *pp );
}

xdr_context( xdrs, context )
XDR		*xdrs;
CONTEXT	*context;
{
	if( xdrs->x_op == XDR_DECODE ) {
		return rcv_context( xdrs, context );
	} else {
		return snd_context( xdrs, context );
	}
}

static
snd_context( xdrs, context )
XDR		*xdrs;
CONTEXT	*context;
{
	EXPR	*expr;
	ELEM	*elem;
	int		i;
	int		status;

		/* Send all the expressions in the context */
	if( context ) {
		for( i=0; i<context->len; i++ ) {
			if( !xdr_expr_ptr(xdrs,&(context->data[i])) ) {
				return FALSE;
			}
		}
	}

		/* Send an endmarker */
	expr = create_expr();
	elem = create_elem();
	elem->type = ENDMARKER;
	add_elem( elem, expr );
	status = xdr_expr_ptr(xdrs,&expr);
	free_expr( expr );

	return status;
}

static
rcv_context( xdrs, context )
XDR		*xdrs;
CONTEXT	*context;
{
	EXPR		*expr;

	if( context == NULL ) {
		EXCEPT( "rcv_context(0x%x,0x%x)", xdrs, context );
	}

	for(;;) {
		expr = NULL;
		if( !xdr_expr_ptr(xdrs,&expr) ) {
			return FALSE;
		}
		if( expr->data[0]->type == ENDMARKER ) {
			free_expr( expr );
			break;
		}
		store_stmt( expr, context );
	}
	return TRUE;
}
