/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/types.h>
#include <sys/dir.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "except.h"
#include "trace.h"
#include "xdr_lib.h"

#ifndef LINT
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */
#endif LINT

xdr_direntries(xdrs, buf, cc)
register XDR *xdrs;
char *buf;
int cc;
{
	register struct direct *direntriesp;
	char *np;

	while( cc > 0 ) {
		direntriesp = (struct direct *) buf;
		np = direntriesp->d_name;
		XDR_ASSERT(xdr_u_long(xdrs, &direntriesp->d_fileno));
		XDR_ASSERT(xdr_u_short(xdrs, &direntriesp->d_reclen));
		XDR_ASSERT(xdr_u_short(xdrs, &direntriesp->d_namlen));
		XDR_ASSERT(xdr_string(xdrs, &np, MAXNAMLEN + 1));

		buf += direntriesp->d_reclen;
		cc  -= direntriesp->d_reclen;
	}

	return( TRUE );
}
