/*
 * Written by Dave Cohrs <dave@cs.wisc.edu>
 */
#include <stdio.h>
#include <utmp.h>
#include <X11/Xlib.h>
#include <sys/time.h>

#define MINUTES 60
#define TRUE 1
#define FALSE 0
#define MATCH 0
#define MIN(a,b) ((a)<(b)?(a):(b))

int xfd;           /* X file descriptor */
Display *dpy = 0;  /* display */
int screen;        /* default screen */
Window rootwindow; /* default root window */
char *host = 0;    /* DISPLAY name */
XEvent event;      /* For events received. */
time_t	last_event;

usage()
{
	fprintf( stderr, "Usage: %s [seconds]\n" );
	exit( 1 );
}

main(argc, argv)
    int argc;
    char *argv[];
{
	int		period = 5;

	if( argc == 2 ) {
		period = atoi( argv[1] );

		if( period <= 0 ) {
			usage( argv[0] );
		}

	}

	wait_until_X_active( period );

		/* open the display and determine well-known some parameters */
    if (!(dpy = XOpenDisplay(host))) {
		fprintf(stderr, "unable to open display '%s'\n",
			XDisplayName(host));
		exit (1);
    }

    screen = DefaultScreen(dpy);
    rootwindow = RootWindow(dpy, screen);
    xfd = ConnectionNumber(dpy);

	last_event = time( (long *)0 );
	for(;;) {
		if( stays_idle(period) ) {
			printf("Idle time is %d seconds\n", time( (long *)0 ) - last_event);
		} else {
			printf( "Idle time is 0 seconds\n" );
			/* printf( "Sleeping\n" ); */
			sleep( period );
			/* printf( "Waking\n" ); */
			last_event = time( (long *)0 );
		}
	}
}

stays_idle( length )
int		length;
{
    fd_set	xmask;              /* mask of file descriptors to check on. */
	int		status;
    struct timeval timeout;    /* holds idle_time timeout */


		/* Grab key and mouse events */
	XGrabKey(dpy, AnyKey, AnyModifier, rootwindow, False,
		 GrabModeSync, GrabModeSync);
	XGrabButton(dpy, AnyButton, AnyModifier, rootwindow, False,
		 ButtonPressMask, GrabModeSync, GrabModeSync, None, None );
	XFlush(dpy);
	/* printf( "Grabbed\n" ); */

		/* Select to see if we get any events */
	timeout.tv_sec = length;
	timeout.tv_usec = 0;
    FD_ZERO(&xmask);
	FD_SET(xfd, &xmask) ;
	status = select(xfd+1, &xmask, (fd_set *) 0, (fd_set *) 0, &timeout);

		/* Eat up any events we got */
	if( status != 0 ) {
		do {
			XNextEvent(dpy, &event);
		} while(XPending(dpy));
	}

		/* Ungrab key and mouse, and replay any events we grabbed */
	XAllowEvents(dpy, ReplayKeyboard, CurrentTime);
	XAllowEvents(dpy, ReplayPointer, CurrentTime);
	XUngrabKey(dpy, AnyKey, AnyModifier, rootwindow);
	XUngrabButton(dpy, AnyButton, AnyModifier, rootwindow);
	XFlush(dpy);
	/* printf( "Ungrabbed\n" ); */

	return status == 0;
}

wait_until_X_active( period )
int		period;
{
	FILE    *fp;
    struct utmp utmp;
	char    XSockName[512];

    if( gethostname(XSockName,sizeof XSockName) < 0 ) {
        perror( "gethostname" );
		exit( 1 );
    }
	strcat( XSockName, ":0" );

    if( (fp=fopen("/etc/utmp","r")) == NULL ) {
        perror( "fopen of utmp" );
		exit( 1 );
    }

	for(;;) {
		while( fread( (char *)&utmp, sizeof utmp, 1, fp ) ) {
			if( utmp.ut_name[0] == '\0' )
				continue;

			if( check_X_active(utmp.ut_host,sizeof(utmp.ut_host),XSockName) ) {
				(void)fclose( fp );
				return;
			}
		}
		sleep( period );
	}

}

check_X_active( ut_host, host_name_len, XSockName )
char    *ut_host;
int		host_name_len;
char	*XSockName;
{
    int     len;
	struct utmp	ut;

    if( strcmp(":0",ut_host) == MATCH ) {
        return TRUE;
    }

    if( strcmp(":0.0",ut_host) == MATCH ) {
        return TRUE;
    }

    if( strcmp("unix:0",ut_host) == MATCH ) {
        return TRUE;
    }

    if( strcmp("unix:0.0",ut_host) == MATCH ) {
        return TRUE;
    }

        /* allow "<localhostname>:0" or "localhostname:0.0" */
    len = MIN( strlen(XSockName), host_name_len );
    if( strncmp(XSockName,ut_host,len) == MATCH ) {
        return TRUE;
    }

    return FALSE;
}
