/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/file.h>
#include <stdio.h>

#include "debug.h"

extern int	DebugFlags;

main( argc, argv )
int argc;
char **argv;
{
	int i, j;
	register int k;
	char buf[ 1024 ];
	int fd;
	extern char CWD[];
	char *curbrk, *oldbrk, *sbrk();

	if( argc > 1 ) {
		DebugFlags |= D_CKPT;
	}

	fprintf( stderr, "CWD = '%s'\n", CWD);

	fd = open( "results", O_CREAT|O_RDWR, 0666);
	if( fd < 0 ) {
		perror("results");
		exit( 1 );
	}

	oldbrk = sbrk(0);

	for( i = 0; ; i++ ) {
		sprintf(buf, "set i = %d\n", i);
		write(fd, buf, strlen(buf));
		lseek(fd , 0, L_SET);

		/*
		fprintf(stderr, buf);
		*/

		curbrk = sbrk(0);
		if( oldbrk != curbrk ) {
			fprintf(stderr, "Current break is now 0x%x, old was 0x%x\n",
				curbrk, oldbrk);
		}

		oldbrk = curbrk;

		for(k=j=0; j < 100000; k++,j++ );
		if( j != k ) {
			sprintf(buf, "j = %d, k (register) = %d\n", j, k);
			fprintf(stderr,"%s", buf);
			write(fileno(stderr), buf, strlen(buf));
		}

		ckpt();
		/*
		*/
	}
}
